
\name{lognormalPOD}

\alias{lognormalPOD}

\title{
Define Probability Of Detection (POD) curve for Non-Destructive
Inspection (NDI) based on a Log-Normal CDF formulation
}

\description{
The POD curve in probabilistic damage tolerance analysis is often
  defined using the formulation of a Log-Normal CDF, with several
  optional modifying parameters. This function can be used to generate the
  appropriate POD function for use in the crackRparameters component "pod.func".
}

\usage{
lognormalPOD(a,median,slope,a.min.detectable=0,poi=1,far=0)
}

\arguments{%% a should not be an argument to this function...it's confusing
  \item{a}{
    Crack length; the sole input to the POD function generated by this function.
}
  \item{median}{
    Median detectable crack length.
}
  \item{slope}{
    Slope parameter (aka sdlog).
}
  \item{a.min.detectable}{
    Crack size below which detection is assumed to be impossible. Below
  this size the generated POD curve returns a zero probability. Note
  the far parameter will override this if far > 0.
}
  \item{poi}{
    Probability Of Inspection. In practice an analyst may assume that
    some percentage of scheduled inspections will not occur as planned
    or will be conducted incorrectly. This can be represented by setting
    poi less than 1, in which case all detection probabilities are
    factored down.
  }
  \item{far}{
    Often in Non-Destructive Inspection (NDI) it is assumed there is no
  false alarm rate. This is most likely untrue. Setting a false alarm
  rate in this function forces a minimum value of POD that will be
  returned from the generated function.
  }
}

\author{
  Keith Halbert <keith.a.halbert@gmail.com>
}

\references{
  MIL-HDBK-1823A (Department of Defense, USA) "Nondestructive Evaluation
  System Reliability Assessment", Apr 2009\cr
  Halbert, K. "Estimation of Probability of Failure for Damage-Tolerant
  Aerospace Structures" PhD Thesis, Temple University Department of
  Statistics, Philadelphia, PA, Apr 2014
}

\note{
  To define a custom POD function based on another type of curve or
  otherwise, the code for \code{crackRlognormalPOD()} is a good place to start.
}

\seealso{
  \code{\link{crackRinit}}\cr
  \code{\link{inspection}}
}

\examples{
myPODcurve <- function(a) lognormalPOD(a, median=0.01, slope=0.5, a.min.detectable =
0, poi = 0.95, far = 0.001)
myPODcurve(c(0, 0.005, 0.01, 0.05, 1))
}

\keyword{reliability}
\keyword{aerospace}
\keyword{fatigue}
\keyword{damage tolerance}