% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_distance_mat.R
\name{get_distance_matrix}
\alias{get_distance_matrix}
\title{Compute all shortest distance between origin and destination nodes.}
\usage{
get_distance_matrix(Graph, from, to, algorithm = "phast",
  allcores = FALSE)
}
\arguments{
\item{Graph}{An object generated by makegraph(), cpp_simplify() or cpp_contract() function.}

\item{from}{A vector of one or more vertices from which distances are calculated (origin).}

\item{to}{A vector of one or more vertices (destination).}

\item{algorithm}{Character. Only for contracted graph, "mch" for Many to many CH, "phast" for PHAST algorithm}

\item{allcores}{Logical. If TRUE, all cores are used.}
}
\value{
Matrix of shortest distances.
}
\description{
Compute all shortest distance between origin and destination nodes.
}
\details{
If graph is not contracted, get_distance_matrix() recursively perform Dijkstra algorithm for each 'from' nodes.
If graph is contracted, the user has the choice between : \itemize{
  \item many to many contraction hierarchies (mch) : optimal for square matrix.  
  \item PHAST (phast) : outperform mch on rectangular matrix
}
 See details in package website : \url{https://github.com/vlarmet/cppRouting/blob/master/README.md}
}
\examples{
#Data describing edges of the graph
edges<-data.frame(from_vertex=c(0,0,1,1,2,2,3,4,4), 
                  to_vertex=c(1,3,2,4,4,5,1,3,5), 
                  cost=c(9,2,11,3,5,12,4,1,6))
#Get all nodes
nodes<-unique(c(edges$from_vertex,edges$to_vertex))
 
#Construct directed and undirected graph 
directed_graph<-makegraph(edges,directed=TRUE)
non_directed<-makegraph(edges,directed=FALSE)

#Get matrix of distance between all nodes in the two graphs
dir_dist<-get_distance_matrix(Graph=directed_graph, from=nodes, to=nodes, allcores=FALSE)
non_dir_dist<-get_distance_matrix(Graph=non_directed, from=nodes, to=nodes, allcores=FALSE)
print(dir_dist)
print(non_dir_dist)
}
