% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot.R
\name{forest_plot}
\alias{forest_plot}
\title{Forest plot}
\usage{
forest_plot(data, facet_formula = "covname~paramname", xlabel = "",
  ylabel = "", x_facet_text_size = 13, y_facet_text_size = 13,
  x_label_text_size = 16, y_label_text_size = 16,
  table_text_size = 7, ref_legend_text = "", area_legend_text = "",
  interval_legend_text = "", legend_order = c("pointinterval", "ref",
  "area", "shape"), combine_area_ref_legend = TRUE,
  show_ref_area = TRUE, ref_area = c(0.8, 1.25), ref_value = 1,
  ref_area_col = "#BEBEBE50", interval_col = "blue",
  strip_col = "#E5E5E5", paramname_shape = FALSE,
  facet_switch = c("both", "y", "x", "none"), facet_scales = c("fixed",
  "free_y", "free_x", "free"), facet_space = c("fixed", "free_x",
  "free_y", "free"), strip_placement = c("inside", "outside"),
  major_x_ticks = NULL, minor_x_ticks = NULL, x_range = NULL,
  show_table_facet_strip = FALSE, table_position = c("right", "below",
  "none"), plot_table_ratio = 4)
}
\arguments{
\item{data}{Data to use.}

\item{facet_formula}{Facet formula.}

\item{xlabel}{X axis title.}

\item{ylabel}{Y axis title.}

\item{x_facet_text_size}{Facet text size X.}

\item{y_facet_text_size}{Facet text size Y.}

\item{x_label_text_size}{X axis labels size.}

\item{y_label_text_size}{Y axis labels size.}

\item{table_text_size}{Table text size.}

\item{ref_legend_text}{Reference legend text.}

\item{area_legend_text}{Area legend text.}

\item{interval_legend_text}{Pointinterval Legend text.}

\item{legend_order}{Legend order. A four-element vector with the following
items ordered in your desired order: "pointinterval", "ref", "area", "shape".}

\item{combine_area_ref_legend}{Combine reference and area legends if they
share the same text?}

\item{show_ref_area}{Show reference window?}

\item{ref_area}{Reference area. Two-element numeric vector.}

\item{ref_value}{X intercept of reference line.}

\item{ref_area_col}{Reference area background color.}

\item{interval_col}{Point range color.}

\item{strip_col}{Strip background color.}

\item{paramname_shape}{Map symbol to parameter(s)?}

\item{facet_switch}{Facet switch to near axis. Possible values: "both", "y",
"x", "none".}

\item{facet_scales}{Facet scales. Possible values: "free_y", "fixed",
"free_x", "free".}

\item{facet_space}{Facet spaces. Possible values: "fixed", "free_x",
"free_y", "free".}

\item{strip_placement}{Strip placement. Possible values: "inside", "outside".}

\item{major_x_ticks}{X axis major ticks. Numeric vector.}

\item{minor_x_ticks}{X axis minor ticks. Numeric vector.}

\item{x_range}{Range of X values. Two-element numeric vector.}

\item{show_table_facet_strip}{Show table facet strip?}

\item{table_position}{Table position. Possible values: "right", "below", "none".}

\item{plot_table_ratio}{Plot-to-table ratio. Suggested value between 1-5.}
}
\description{
Produce forest plots to visualize covariate effects
}
\examples{
library(dplyr)

# Example 1

plotdata <- get_sample_data("forest-plot-table.csv")
plotdata <- plotdata \%>\%
  mutate(midlabel = format(round(mid,2), nsmall = 2),
         lowerlabel = format(round(lower,2), nsmall = 2),
         upperlabel = format(round(upper,2), nsmall = 2),
         LABEL = paste0(midlabel, " [", lowerlabel, "-", upperlabel, "]"))
param <- "BZD AUC"
plotdata <-  filter(plotdata,paramname==param)
plotdata$covname <- reorder(plotdata$covname,plotdata$upper,FUN =max)
plotdata$label <- reorder(plotdata$label,plotdata$scen)
covs <- c("WEIGHT","AGE")
plotdata <-  filter(plotdata,covname\%in\%covs)
forest_plot(plotdata,
            ref_legend_text = "Reference (vertical line)",
            area_legend_text = "Reference (vertical line)",
            xlabel = paste("Fold Change in", param, "Relative to Reference"),
            show_ref_area = FALSE,
            facet_formula = "covname~.",
            facet_scales = "free_y",
            facet_space = "free_y",
            show_table_facet_strip = FALSE,
            table_position = "right",
            plot_table_ratio = 4)

# Example 2

plotdata <- get_sample_data("forest-plot-table.csv")
plotdata <- plotdata \%>\%
  mutate(midlabel = format(round(mid,2), nsmall = 2),
         lowerlabel = format(round(lower,2), nsmall = 2),
         upperlabel = format(round(upper,2), nsmall = 2),
         LABEL = paste0(midlabel, " [", lowerlabel, "-", upperlabel, "]"))
param <- c("BZD AUC","BZD Cmax")
plotdata <-  filter(plotdata,paramname\%in\%param)
plotdata <-  filter(plotdata,covname\%in\%"WEIGHT")
plotdata$covname <- reorder(plotdata$covname,plotdata$upper,FUN =max)
plotdata$label <- reorder(plotdata$label,plotdata$scen)
forest_plot(plotdata,
            ref_legend_text = "Reference (vertical line)",
            area_legend_text = "Reference (vertical line)",
            xlabel = paste("Fold Change of Parameter", "Relative to Reference"),
            show_ref_area = FALSE,
            facet_formula = "covname~paramname",
            facet_scales = "free_y",
            facet_space = "free_y",
            x_facet_text_size = 10,
            y_facet_text_size = 10,
            y_label_text_size = 10,
            x_label_text_size = 10,
            facet_switch = "both",
            show_table_facet_strip = TRUE,
            table_position = "below",
            plot_table_ratio = 1)
\dontrun{
# Example 3

plotdata <- get_sample_data("forestplotdatacpidata.csv")
forest_plot(plotdata,
            ref_area = c(0.8, 1.2),
            x_facet_text_size = 12,
            y_facet_text_size = 12,
            y_label_text_size = 10,
            x_label_text_size = 10,
            table_text_size = 6,
            plot_table_ratio = 1.5,
            ref_legend_text = "Reference (vertical line)\\n+/- 20\% limits (colored area)",
            area_legend_text = "Reference (vertical line)\\n+/- 20\% limits (colored area)",
            xlabel = "Fold Change Relative to RHZE",
            facet_formula = "covname~paramname",
            table_position = "below")

# Example 4
plotdata <- get_sample_data("dataforest.csv")
plotdata <- plotdata \%>\%
  mutate(midlabel = format(round(mid,2), nsmall = 2),
         lowerlabel = format(round(lower,2), nsmall = 2),
         upperlabel = format(round(upper,2), nsmall = 2),
         LABEL = paste0(midlabel, " [", lowerlabel, "-", upperlabel, "]"))
plotdata <- plotdata \%>\%
  filter(covname\%in\%c("Weight"))
plotdata$label <- as.factor(as.character(plotdata$label))
plotdata$label <- factor(plotdata$label, c("36.2 kg","66 kg","110 kg"))
forest_plot(plotdata,
            ref_area = c(0.8, 1.2),
            x_facet_text_size = 13,
            y_facet_text_size = 13,
            ref_legend_text = "Reference (vertical line)\\n+/- 20\% limits (colored area)",
            area_legend_text = "Reference (vertical line)\\n+/- 20\% limits (colored area)",
            xlabel = "Fold Change Relative to Parameter",
            facet_formula = "covname~paramname",
            facet_switch = "both",
            facet_scales = "free",
            facet_space = "fixed",
            table_position = "below",
            plot_table_ratio = 1)

# Example 5

forest_plot(plotdata,
            ref_area = c(0.8, 1.2),
            x_facet_text_size = 13,
            y_facet_text_size = 13,
            ref_legend_text = "Reference (vertical line)\\n+/- 20\% limits (colored area)",
            area_legend_text = "Reference (vertical line)\\n+/- 20\% limits (colored area)",
            xlabel = "Fold Change Relative to Parameter",
            facet_formula = "covname~.",
            facet_switch = "both",
            facet_scales = "free",
            facet_space = "fixed",
            paramname_shape = TRUE,
            table_position = "below",
            plot_table_ratio = 1)
}
}
