% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covablocks.R
\docType{class}
\name{covablocks-class}
\alias{covablocks-class}
\alias{covablocks}
\alias{show,covablocks-method}
\title{Class "covablocks"}
\usage{
covablocks(stblocks, stpairs, typetest = "sym")

\S4method{show}{covablocks}(object)
}
\arguments{
\item{stblocks}{object of class \code{blocks}}

\item{stpairs}{object of class \code{couples}, containing the spatial
points and the corresponding temporal lags to be analyzed}

\item{typetest}{character; set \code{typetest ="sym"} for symmetry test
(default choice), \code{typetest ="sep"} for separability test, \code{typetest ="tnSep"}
for type of non separability test,\code{typetest ="productSum"} for the test
on the product-sum class of models, \code{typetest ="intProduct"} for the test
on the integrated product class of models, \code{typetest ="gneiting"} for the
test on the Gneiting class of models}

\item{object}{object of class \code{covablocks} for method \code{show}}
}
\description{
A class for the sample spatio-temporal covariances to be computed for each
block of data and for the selected spatial and temporal lags fixed
in \code{stpairs} (output from \code{couples}). Depending on the type of
test the empirical variance, the sample spatial and temporal marginal
covariances for each block of data are also computed. Moreover, the sample
covariances between the spatio-temporal covariances at the specified spatial
and temporal lags are determined.
}
\section{Slots}{

\describe{
\item{\code{mat.cova}}{matrix of sample spatio-temporal covariances for each block,
computed for the spatial and temporal lags given in \code{stpairs}
(object of class \code{couples})}

\item{\code{mat.cova.h}}{matrix of sample spatial marginal covariances
for the specified lags}

\item{\code{mat.cova.u}}{matrix of sample temporal marginal covariances
for the specified lags}

\item{\code{mat.cova.cova}}{matrix of sample covariances between space-time
covariances for each block, computed for the spatial and temporal lags given
in \code{stpairs} (object of class \code{couples})}

\item{\code{typetest}}{character; contains the code of the test to be performed}
}}

\note{
{
\itemize{
\item If \code{typetest} is equal to \code{"sym"} (symmetry test) or \code{"intProduct"}
(test on the integrated product class of models) \code{mat.cova.h} and \code{mat.cova.u}
are not available

\item If \code{typetest} is equal to \code{"gneiting"} (test on the Gneiting
class of models) \code{mat.cova.h} is not available

\item If temporal lags in \code{stpairs} are not consistent with block length
(\code{lb}) in \code{stblocks} an error message will be returned

\item If the proportion between the maximum temporal lag in \code{stpairs} and
the block length (\code{lb}) in \code{stblocks} is greater than 0.25 a warning
message will be returned since the covariance estimation might not be reliable
}
}
}
\examples{
# --start define the STFDF rr_13-- #
library(sp)
library(spacetime)
library(gstat)
data(air)
ls()
if (!exists("rural")) rural = STFDF(stations, dates, data.frame(PM10 =
as.vector(air)))
rr = rural[,"2005::2010"]
unsel = which(apply(as(rr, "xts"), 2, function(x) all(is.na(x))))
r5to10 = rr[-unsel,]
rr_13 <- r5to10[c("DEHE046","DESN049","DETH026","DENW063","DETH061","DEBY047",
"DENW065","DEUB029","DENW068","DENI019","DEHE051","DERP016","DENI051"),
"2005::2006"]
# --end define the STFDF rr_13-- #

sel.staz.sym <- c("DERP016", "DENW065", "DEHE051", "DETH026", "DENW063", "DENI019",
"DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049")

sp.couples.in.sym <- matrix(data = c("DERP016", "DENW065", "DEHE051", "DETH026",
"DENW063", "DENI019", "DENW068", "DEHE046", "DEUB029", "DEBY047", "DETH061", "DESN049"),
ncol = 2, byrow = TRUE)

t.couples.in.sym <- c(1, 2)

couples.sym <- couples(sel.staz = sel.staz.sym, sp.couples.in = sp.couples.in.sym,
t.couples.in = t.couples.in.sym, typetest = "sym", typecode = character())

block.sym <- blocks(lb = 40, ls = 10, matdata = rr_13, pardata1 = 1, pardata2 = 1,
stpairs = couples.sym)

covabl.sym <- covablocks(stblocks = block.sym, stpairs = couples.sym, typetest = "sym")

### method for covablock
#1. show
covabl.sym

}
\references{
Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Cappello, C., De Iaco, S., Posa, D., 2018, Testing the type of
non-separability and some classes of covariance models for space-time data.
Stochastic Environmental Research and Risk Assessment,
\bold{32} 17--35
}
\seealso{
\linkS4class{blocks}

\linkS4class{couples}
}
