% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covaprop.R
\name{covaprop}
\alias{covaprop}
\title{Tests properties of S-T covariance functions}
\usage{
covaprop(cblock, cstat, typetest, nonseptype = NULL, sign.level = 0.05)
}
\arguments{
\item{cblock}{object of class \code{covablocks}}

\item{cstat}{object of class \code{covastat}}

\item{typetest}{integer; set \code{typetest=0} for simmetry test (default
choice), \code{typetest=1} for separability test, \code{typetest=2} for type
of non separability test, \code{typetest=3} for the test on the product-sum
class of models, \code{typetest=4} for the test on the integrated product
class of models, \code{typetest=5} for the test on the Gneiting class of
models}

\item{nonseptype}{integer; this argumet is required only for \code{typetest}=2,
otherwise it has to be set equal to \code{NULL} (default choice).
Set \code{nonseptype=0} for testing the null hypothesis that the non
separability is non positive; set \code{nonseptype=1} for testing the null
hypothesis that the non separability is non negative}

\item{sign.level}{level of significance}
}
\value{
The value of the test statistic and the lower tail p-value of the
test statistic. Moreover a message helps to decide for either reject the null
hypothesis in favor of the alternative or not reject it, at a specific level
of significance
}
\description{
A function for testing some properties (simmetry, separability, type of
non-separability) of spatio-temporal covariance functions and some classes
of space-time covariance models
}
\note{
{
\itemize{
\item The test on full simmetry (\code{typetest=0}) represents the first step
for the selection of a suitable class of spatio-temporal covariance functions.
According to the definition of full simmetry, the null hypothesis to be
tested is \eqn{H_0: C(h,u) - C(h,-u)=0}

\item The test of separability (\code{typetest=1}) represents the second
step of the testing procedure. According to the definition of separability,
the null hypothesis to be tested is
\eqn{H_0: C(h, u)/C(h, 0) - C(0, u)/C(0,0)=0}

\item The test on the type of non separability (\code{typetest=2})
represents the third step for the selection of a suitable class of space-time
covariance functions.
According to the definition of type of non separability, the null hypothesis
to be tested is that the non separability is non negative
\eqn{H_0: C(h,u)/C(h,0) - C(0,u)/C(0,0) > 0}
or
\eqn{H_0: C(h,u)/C(h,0) - C(0,u)/C(0,0) < 0}
if the null hypothesis to test is that the non separability is non positive

\item \code{typetest} from 3 to 5 are useful to test the goodness of a
specific class of space-time covariance function. For this testing procedure
the generic null hypothesis is: \eqn{H_0: Af(G)=0}
}
For the analytic expression of each test statistic and its probability
distribution see references. In the same contribution the
different \code{f(G)} are given for each test to be computed.
}
}
\examples{
# Before running this function, it is necessary to execute couples, blocks,
# covablocks and covastat, as specified in the examples of the corresponding
# help pages.
#
# To run the example, paste and copy the following lines
# (without the symbol '#') in the console
#
# coupl_sim <- couples(typetest = 0, typecode = character())
# blocks_sim <- blocks(lb = 40, ls = 10, matdata = rr_13, stpairs = coupl_sim)
# covabl_sim <- covablocks(stblocks = blocks_sim, stpairs = coupl_sim, typetest = 0)
# covast_sim <- covastat(matdata = rr_13, stpairs = coupl_sim, typetest = 0)
# covaprop(cblock = covabl_sim, cstat = covast_sim, typetest = 0, nonseptype = NULL,
# sign.level = 0.05)

}
\references{
Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Cappello, C., De Iaco, S., Posa, D., 2016, Testing the type of
non-separability and some classes of covariance models for space-time data.
(submitted)
}
\seealso{
\linkS4class{couples}

\linkS4class{blocks}

\linkS4class{covablocks}

\linkS4class{covastat}
}
