% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fisher2012.R
\name{Fisher2012}
\alias{Fisher2012}
\title{Test of Structure of a Covariance Matrix given by Fisher 2012}
\usage{
Fisher2012(x, Sigma = "identity", ...)
}
\arguments{
\item{x}{data}

\item{Sigma}{Population covariance matrix}

\item{...}{other options passed to covTest method}
}
\value{
A list with class "htest" containing the following components:

\tabular{ll}{
\code{statistic} \tab the value of equality of covariance test statistic \cr
\tab \cr
\code{parameter} \tab the degrees of freedom for the chi-squared statistic \cr
\tab \cr
\code{p.value} \tab the p=value for the test \cr
\tab \cr
\code{estimate} \tab the estimated covariances if less than 5 dimensions \cr
\tab \cr
\code{null.value} \tab the specified hypothesized value of the covariance difference \cr
\tab \cr
\code{alternative} \tab a character string describing the alternative hyposthesis \cr
\tab \cr
\code{method} \tab a character string indicating what type of equality of covariance test was performed \cr
\tab \cr
\code{data.name} \tab a character string giving the names of the data
}
}
\description{
Test of Structure of a Covariance Matrix given by Fisher 2012
}
\details{
The \code{\link{structureCovariances}} function is a wrapper function that formats the data 
  for the specific \code{covTest} functions.
}
\examples{
Fisher2012(as.matrix(iris[1:50, 1:4]))

}
\references{
Fisher, T. J. (2012). On Testing for an Identity Covariance Matrix when the Dimensionality Equals or Exceeds the Sample Size. Journal of Statistical Planning and Infernece, 142(1), 312-326. \doi{10.1016/j.jspi.2011.07.019}
}
