% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CounterfactualMethodRegr.R
\name{CounterfactualMethodRegr}
\alias{CounterfactualMethodRegr}
\title{Base class for Counterfactual Explanation Methods for Regression Tasks}
\description{
Abstract base class for counterfactual explanation methods for regression tasks.

\code{CounterfactualMethodRegr} can only be initialized for regression tasks. Child classes inherit the (public)
\verb{$find_counterfactuals()} method, which calls a (private) \verb{$run()} method. This \verb{$run()} method should be implemented
by the child classes and return the counterfactuals as a \code{data.table} (preferably) or a \code{data.frame}.
}
\section{Inheritance}{

Child classes: \link{MOCRegr}, \link{WhatIfRegr}, \link{NICERegr}
}

\section{Super class}{
\code{\link[counterfactuals:CounterfactualMethod]{counterfactuals::CounterfactualMethod}} -> \code{CounterfactualMethodRegr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CounterfactualMethodRegr-new}{\code{CounterfactualMethodRegr$new()}}
\item \href{#method-CounterfactualMethodRegr-find_counterfactuals}{\code{CounterfactualMethodRegr$find_counterfactuals()}}
\item \href{#method-CounterfactualMethodRegr-clone}{\code{CounterfactualMethodRegr$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethod" data-id="print"><a href='../../counterfactuals/html/CounterfactualMethod.html#method-CounterfactualMethod-print'><code>counterfactuals::CounterfactualMethod$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CounterfactualMethodRegr-new"></a>}}
\if{latex}{\out{\hypertarget{method-CounterfactualMethodRegr-new}{}}}
\subsection{Method \code{new()}}{
Creates a new CounterfactualMethodRegr object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CounterfactualMethodRegr$new(
  predictor,
  lower = NULL,
  upper = NULL,
  distance_function = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{(\link[iml]{Predictor})\cr
The object (created with \code{iml::Predictor$new()}) holding the machine learning model and the data.}

\item{\code{lower}}{(\code{numeric()} | \code{NULL})\cr
Vector of minimum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{lower} is taken as its minimum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{upper}}{(\code{numeric()} | \code{NULL})\cr
Vector of maximum values for numeric features.
If \code{NULL} (default), the element for each numeric feature in \code{upper} is taken as its maximum value in \code{predictor$data$X}.
If not \code{NULL}, it should be named with the corresponding feature names.}

\item{\code{distance_function}}{(\verb{function()} | \code{NULL})\cr
A distance function that may be used by the leaf classes.
If specified, the function must have three arguments: \code{x}, \code{y}, and \code{data} and return a \code{double} matrix with \code{nrow(x)}
rows and \code{nrow(y)} columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CounterfactualMethodRegr-find_counterfactuals"></a>}}
\if{latex}{\out{\hypertarget{method-CounterfactualMethodRegr-find_counterfactuals}{}}}
\subsection{Method \code{find_counterfactuals()}}{
Runs the counterfactual method and returns the counterfactuals.
It searches for counterfactuals that have a predicted outcome in the interval \code{desired_outcome}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CounterfactualMethodRegr$find_counterfactuals(x_interest, desired_outcome)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_interest}}{(\code{data.table(1)} | \code{data.frame(1)}) \cr
A single row with the observation of interest.}

\item{\code{desired_outcome}}{(\code{numeric(1)} | \code{numeric(2)}) \cr
The desired predicted outcome. It can be a numeric scalar or a vector with two numeric values that specify an
outcome interval. A scalar is internally converted to an interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{Counterfactuals} object containing the results.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CounterfactualMethodRegr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CounterfactualMethodRegr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CounterfactualMethodRegr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
