% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{as_cordf}
\alias{as_cordf}
\title{Coerce lists and matrices to correlation data frames}
\usage{
as_cordf(x, diagonal = NA)
}
\arguments{
\item{x}{A list, data frame or matrix that can be coerced into a correlation
data frame.}

\item{diagonal}{Value (typically numeric or NA) to set the diagonal to.}
}
\value{
A correlation data frame
}
\description{
A wrapper function to coerce objects in a valid format (such as correlation
matrices created using the base function, \code{\link[stats]{cor}}) into a
correlation data frame.
}
\examples{
x <- cor(mtcars)
as_cordf(x)
as_cordf(x, diagonal = 1)
}
