% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsyntax.r
\name{transform_rsyntax}
\alias{transform_rsyntax}
\title{Apply rsyntax transformations}
\usage{
transform_rsyntax(tc, f, ...)
}
\arguments{
\item{tc}{a tCorpus}

\item{f}{functions that perform rsyntax tree transformations}

\item{...}{arguments passed to f}
}
\value{
a tCorpus after applying the transformations
}
\description{
This is an experimental function for applying rsyntax transformations directly on a tcorpus,
to create a new tcorpus with the transformed tokens. The argument f should be self defined function
that wraps rsyntax transformations. Or more generally, a function that takes a tokens data.frame (or data.table) as input, and returns a tokens data.frame (or data.table). 
For examples, see corpustools:::ud_relcl, or corpustools::udpipe_simplify for a function that wraps multiple transformations.
}
\examples{
if (interactive()) {
tc = tc_sotu_udpipe$copy()
tc2 = transform_rsyntax(tc, udpipe_simplify)

browse_texts(tc2)
   rsyntax::plot_tree(tc$tokens, token, lemma, POS, sentence_i=20)
   rsyntax::plot_tree(tc2$tokens, token, lemma, POS, sentence_i=20)
}
}
