% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_dictionary.r
\name{search_dictionary}
\alias{search_dictionary}
\title{Dictionary lookup}
\usage{
search_dictionary(tc, dict, token_col = "token", case_sensitive = F,
  batchsize = 50000, flatten_colloc = T, ascii = F, low_memory = F,
  verbose = F)
}
\arguments{
\item{tc}{A tCorpus}

\item{dict}{A dictionary. Can be either a data.frame or a quanteda dictionary. If a data.frame is given, it has to
have a column named "string" that contains the dictionary terms, and a column "code" that contains the
label/code represented by this string. Each row has a single string, that can be
a single word or a sequence of words seperated by a whitespace (e.g., "not bad"), and can have the common ? and * wildcards.
If a quanteda dictionary is given, it is automatically converted to this type of data.frame with the
\code{\link{melt_quanteda_dict}} function. This can be done manually for more control over labels.}

\item{token_col}{The feature in tc that contains the token text.}

\item{case_sensitive}{logical, should lookup be case sensitive?}

\item{batchsize}{Very large dictionaries will be matched in batches to prevent memory issues.}

\item{flatten_colloc}{If true, collocations in the tokens (rows in tc$tokens) will be considered separate words. For example, "President_Obama" will be split to "president" "obama", so that "president obama" in the dictionary matches correctly.}

\item{ascii}{If true, convert text to ascii before matching}

\item{low_memory}{if true, use slower but more memory efficient computation}

\item{verbose}{If true, report progress}
}
\value{
A vector with the id value (taken from dict$id) for each row in tc$tokens
}
\description{
Similar to search_features, but for fast matching of large dictionaries.
}
\examples{
dict = data.frame(string = c('this is', 'for a', 'not big enough'), code=c('a','c','b'))
tc = create_tcorpus(c('this is a test','This town is not big enough for a test'))
search_dictionary(tc, dict)$hits
}
