/* This file is automatically generated. DO NOT EDIT!
   Instead, edit gen-casefold.py and re-run.  */

/*
 * Case folding properties.
 *
 * Defined in UAX #44 "Unicode Character Database"
 *
 *     http://www.unicode.org/reports/tr44/
 *
 * Section 5.6, Case and Case Mapping
 *
 *
 * We use a two-stage lookup strategy as described at
 *
 *     http://www.strchr.com/multi-stage_tables
 *
 */

#ifndef UNICODE_CASEFOLD_H
#define UNICODE_CASEFOLD_H

#include <stdint.h>

/* casefold
 * --------
 * length: the length (in codepoints) of the case fold mapping,
 *         or 0 if there is no case fold
 *
 * data:   the mapped-to codepoint (length = 1), or
 *         an index into the `casefold_mapping` array, pointing
 *         to the first codepoint in the mapping (length > 1)
 */
struct casefold {
	unsigned length : 8;
	unsigned data : 24;
};

#define CASEFOLD_BLOCK_SIZE 256

static const uint8_t casefold_stage1[] = {
/* U+0000 */  0,  1,  2,  3,  4,  5,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+1000 */  7,  6,  6,  8,  6,  6,  6,  6,  6,  6,  6,  6,  9,  6, 10, 11,
/* U+2000 */  6, 12,  6,  6, 13,  6,  6,  6,  6,  6,  6,  6, 14,  6,  6,  6,
/* U+3000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+4000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+5000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+6000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+7000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+8000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+9000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A000 */  6,  6,  6,  6,  6,  6, 15, 16,  6,  6,  6, 17,  6,  6,  6,  6,
/* U+B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6, 18,  6,  6,  6, 19,
/* U+10000 */  6,  6,  6,  6, 20,  6,  6,  6,  6,  6,  6,  6, 21,  6,  6,  6,
/* U+11000 */  6,  6,  6,  6,  6,  6,  6,  6, 22,  6,  6,  6,  6,  6,  6,  6,
/* U+12000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+13000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+14000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+15000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+16000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+17000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+18000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+19000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+1A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+1B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+1C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+1D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+1E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6, 23,  6,  6,  6,  6,  6,  6,
/* U+1F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+20000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+21000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+22000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+23000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+24000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+25000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+26000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+27000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+28000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+29000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+2A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+2B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+2C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+2D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+2E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+2F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+30000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+31000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+32000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+33000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+34000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+35000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+36000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+37000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+38000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+39000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+3A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+3B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+3C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+3D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+3E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+3F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+40000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+41000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+42000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+43000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+44000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+45000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+46000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+47000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+48000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+49000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+4A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+4B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+4C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+4D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+4E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+4F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+50000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+51000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+52000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+53000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+54000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+55000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+56000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+57000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+58000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+59000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+5A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+5B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+5C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+5D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+5E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+5F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+60000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+61000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+62000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+63000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+64000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+65000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+66000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+67000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+68000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+69000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+6A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+6B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+6C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+6D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+6E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+6F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+70000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+71000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+72000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+73000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+74000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+75000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+76000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+77000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+78000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+79000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+7A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+7B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+7C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+7D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+7E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+7F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+80000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+81000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+82000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+83000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+84000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+85000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+86000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+87000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+88000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+89000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+8A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+8B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+8C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+8D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+8E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+8F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+90000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+91000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+92000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+93000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+94000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+95000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+96000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+97000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+98000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+99000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+9A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+9B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+9C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+9D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+9E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+9F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A0000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A1000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A2000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A3000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A4000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A5000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A6000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A7000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A8000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+A9000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+AA000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+AB000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+AC000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+AD000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+AE000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+AF000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B0000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B1000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B2000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B3000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B4000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B5000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B6000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B7000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B8000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+B9000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+BA000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+BB000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+BC000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+BD000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+BE000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+BF000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C0000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C1000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C2000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C3000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C4000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C5000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C6000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C7000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C8000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+C9000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+CA000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+CB000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+CC000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+CD000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+CE000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+CF000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D0000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D1000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D2000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D3000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D4000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D5000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D6000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D7000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D8000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+D9000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+DA000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+DB000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+DC000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+DD000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+DE000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+DF000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E0000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E1000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E2000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E3000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E4000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E5000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E6000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E7000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E8000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+E9000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+EA000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+EB000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+EC000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+ED000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+EE000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+EF000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F0000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F1000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F2000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F3000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F4000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F5000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F6000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F7000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F8000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+F9000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+FA000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+FB000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+FC000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+FD000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+FE000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+FF000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+100000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+101000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+102000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+103000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+104000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+105000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+106000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+107000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+108000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+109000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+10A000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+10B000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+10C000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+10D000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+10E000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
/* U+10F000 */  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6
};

static const struct casefold casefold_stage2[][256] = {
  /* block 0 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {1,0x00061},{1,0x00062},{1,0x00063},{1,0x00064},{1,0x00065},
   {1,0x00066},{1,0x00067},{1,0x00068},{1,0x00069},{1,0x0006A},
   {1,0x0006B},{1,0x0006C},{1,0x0006D},{1,0x0006E},{1,0x0006F},
   {1,0x00070},{1,0x00071},{1,0x00072},{1,0x00073},{1,0x00074},
   {1,0x00075},{1,0x00076},{1,0x00077},{1,0x00078},{1,0x00079},
   {1,0x0007A},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x003BC},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{1,0x000E0},{1,0x000E1},{1,0x000E2},
   {1,0x000E3},{1,0x000E4},{1,0x000E5},{1,0x000E6},{1,0x000E7},
   {1,0x000E8},{1,0x000E9},{1,0x000EA},{1,0x000EB},{1,0x000EC},
   {1,0x000ED},{1,0x000EE},{1,0x000EF},{1,0x000F0},{1,0x000F1},
   {1,0x000F2},{1,0x000F3},{1,0x000F4},{1,0x000F5},{1,0x000F6},
   {0,0},{1,0x000F8},{1,0x000F9},{1,0x000FA},{1,0x000FB},
   {1,0x000FC},{1,0x000FD},{1,0x000FE},{2,0x00000},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 1 */
  {{1,0x00101},{0,0},{1,0x00103},{0,0},{1,0x00105},
   {0,0},{1,0x00107},{0,0},{1,0x00109},{0,0},
   {1,0x0010B},{0,0},{1,0x0010D},{0,0},{1,0x0010F},
   {0,0},{1,0x00111},{0,0},{1,0x00113},{0,0},
   {1,0x00115},{0,0},{1,0x00117},{0,0},{1,0x00119},
   {0,0},{1,0x0011B},{0,0},{1,0x0011D},{0,0},
   {1,0x0011F},{0,0},{1,0x00121},{0,0},{1,0x00123},
   {0,0},{1,0x00125},{0,0},{1,0x00127},{0,0},
   {1,0x00129},{0,0},{1,0x0012B},{0,0},{1,0x0012D},
   {0,0},{1,0x0012F},{0,0},{2,0x00002},{0,0},
   {1,0x00133},{0,0},{1,0x00135},{0,0},{1,0x00137},
   {0,0},{0,0},{1,0x0013A},{0,0},{1,0x0013C},
   {0,0},{1,0x0013E},{0,0},{1,0x00140},{0,0},
   {1,0x00142},{0,0},{1,0x00144},{0,0},{1,0x00146},
   {0,0},{1,0x00148},{0,0},{2,0x00004},{1,0x0014B},
   {0,0},{1,0x0014D},{0,0},{1,0x0014F},{0,0},
   {1,0x00151},{0,0},{1,0x00153},{0,0},{1,0x00155},
   {0,0},{1,0x00157},{0,0},{1,0x00159},{0,0},
   {1,0x0015B},{0,0},{1,0x0015D},{0,0},{1,0x0015F},
   {0,0},{1,0x00161},{0,0},{1,0x00163},{0,0},
   {1,0x00165},{0,0},{1,0x00167},{0,0},{1,0x00169},
   {0,0},{1,0x0016B},{0,0},{1,0x0016D},{0,0},
   {1,0x0016F},{0,0},{1,0x00171},{0,0},{1,0x00173},
   {0,0},{1,0x00175},{0,0},{1,0x00177},{0,0},
   {1,0x000FF},{1,0x0017A},{0,0},{1,0x0017C},{0,0},
   {1,0x0017E},{0,0},{1,0x00073},{0,0},{1,0x00253},
   {1,0x00183},{0,0},{1,0x00185},{0,0},{1,0x00254},
   {1,0x00188},{0,0},{1,0x00256},{1,0x00257},{1,0x0018C},
   {0,0},{0,0},{1,0x001DD},{1,0x00259},{1,0x0025B},
   {1,0x00192},{0,0},{1,0x00260},{1,0x00263},{0,0},
   {1,0x00269},{1,0x00268},{1,0x00199},{0,0},{0,0},
   {0,0},{1,0x0026F},{1,0x00272},{0,0},{1,0x00275},
   {1,0x001A1},{0,0},{1,0x001A3},{0,0},{1,0x001A5},
   {0,0},{1,0x00280},{1,0x001A8},{0,0},{1,0x00283},
   {0,0},{0,0},{1,0x001AD},{0,0},{1,0x00288},
   {1,0x001B0},{0,0},{1,0x0028A},{1,0x0028B},{1,0x001B4},
   {0,0},{1,0x001B6},{0,0},{1,0x00292},{1,0x001B9},
   {0,0},{0,0},{0,0},{1,0x001BD},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x001C6},{1,0x001C6},{0,0},{1,0x001C9},
   {1,0x001C9},{0,0},{1,0x001CC},{1,0x001CC},{0,0},
   {1,0x001CE},{0,0},{1,0x001D0},{0,0},{1,0x001D2},
   {0,0},{1,0x001D4},{0,0},{1,0x001D6},{0,0},
   {1,0x001D8},{0,0},{1,0x001DA},{0,0},{1,0x001DC},
   {0,0},{0,0},{1,0x001DF},{0,0},{1,0x001E1},
   {0,0},{1,0x001E3},{0,0},{1,0x001E5},{0,0},
   {1,0x001E7},{0,0},{1,0x001E9},{0,0},{1,0x001EB},
   {0,0},{1,0x001ED},{0,0},{1,0x001EF},{0,0},
   {2,0x00006},{1,0x001F3},{1,0x001F3},{0,0},{1,0x001F5},
   {0,0},{1,0x00195},{1,0x001BF},{1,0x001F9},{0,0},
   {1,0x001FB},{0,0},{1,0x001FD},{0,0},{1,0x001FF},
   {0,0}
  },

  /* block 2 */
  {{1,0x00201},{0,0},{1,0x00203},{0,0},{1,0x00205},
   {0,0},{1,0x00207},{0,0},{1,0x00209},{0,0},
   {1,0x0020B},{0,0},{1,0x0020D},{0,0},{1,0x0020F},
   {0,0},{1,0x00211},{0,0},{1,0x00213},{0,0},
   {1,0x00215},{0,0},{1,0x00217},{0,0},{1,0x00219},
   {0,0},{1,0x0021B},{0,0},{1,0x0021D},{0,0},
   {1,0x0021F},{0,0},{1,0x0019E},{0,0},{1,0x00223},
   {0,0},{1,0x00225},{0,0},{1,0x00227},{0,0},
   {1,0x00229},{0,0},{1,0x0022B},{0,0},{1,0x0022D},
   {0,0},{1,0x0022F},{0,0},{1,0x00231},{0,0},
   {1,0x00233},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{1,0x02C65},{1,0x0023C},
   {0,0},{1,0x0019A},{1,0x02C66},{0,0},{0,0},
   {1,0x00242},{0,0},{1,0x00180},{1,0x00289},{1,0x0028C},
   {1,0x00247},{0,0},{1,0x00249},{0,0},{1,0x0024B},
   {0,0},{1,0x0024D},{0,0},{1,0x0024F},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 3 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{1,0x003B9},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{1,0x00371},{0,0},{1,0x00373},
   {0,0},{0,0},{0,0},{1,0x00377},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{1,0x003F3},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{1,0x003AC},
   {0,0},{1,0x003AD},{1,0x003AE},{1,0x003AF},{0,0},
   {1,0x003CC},{0,0},{1,0x003CD},{1,0x003CE},{3,0x00008},
   {1,0x003B1},{1,0x003B2},{1,0x003B3},{1,0x003B4},{1,0x003B5},
   {1,0x003B6},{1,0x003B7},{1,0x003B8},{1,0x003B9},{1,0x003BA},
   {1,0x003BB},{1,0x003BC},{1,0x003BD},{1,0x003BE},{1,0x003BF},
   {1,0x003C0},{1,0x003C1},{0,0},{1,0x003C3},{1,0x003C4},
   {1,0x003C5},{1,0x003C6},{1,0x003C7},{1,0x003C8},{1,0x003C9},
   {1,0x003CA},{1,0x003CB},{0,0},{0,0},{0,0},
   {0,0},{3,0x0000B},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{1,0x003C3},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{1,0x003D7},{1,0x003B2},{1,0x003B8},
   {0,0},{0,0},{0,0},{1,0x003C6},{1,0x003C0},
   {0,0},{1,0x003D9},{0,0},{1,0x003DB},{0,0},
   {1,0x003DD},{0,0},{1,0x003DF},{0,0},{1,0x003E1},
   {0,0},{1,0x003E3},{0,0},{1,0x003E5},{0,0},
   {1,0x003E7},{0,0},{1,0x003E9},{0,0},{1,0x003EB},
   {0,0},{1,0x003ED},{0,0},{1,0x003EF},{0,0},
   {1,0x003BA},{1,0x003C1},{0,0},{0,0},{1,0x003B8},
   {1,0x003B5},{0,0},{1,0x003F8},{0,0},{1,0x003F2},
   {1,0x003FB},{0,0},{0,0},{1,0x0037B},{1,0x0037C},
   {1,0x0037D}
  },

  /* block 4 */
  {{1,0x00450},{1,0x00451},{1,0x00452},{1,0x00453},{1,0x00454},
   {1,0x00455},{1,0x00456},{1,0x00457},{1,0x00458},{1,0x00459},
   {1,0x0045A},{1,0x0045B},{1,0x0045C},{1,0x0045D},{1,0x0045E},
   {1,0x0045F},{1,0x00430},{1,0x00431},{1,0x00432},{1,0x00433},
   {1,0x00434},{1,0x00435},{1,0x00436},{1,0x00437},{1,0x00438},
   {1,0x00439},{1,0x0043A},{1,0x0043B},{1,0x0043C},{1,0x0043D},
   {1,0x0043E},{1,0x0043F},{1,0x00440},{1,0x00441},{1,0x00442},
   {1,0x00443},{1,0x00444},{1,0x00445},{1,0x00446},{1,0x00447},
   {1,0x00448},{1,0x00449},{1,0x0044A},{1,0x0044B},{1,0x0044C},
   {1,0x0044D},{1,0x0044E},{1,0x0044F},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x00461},{0,0},{1,0x00463},{0,0},
   {1,0x00465},{0,0},{1,0x00467},{0,0},{1,0x00469},
   {0,0},{1,0x0046B},{0,0},{1,0x0046D},{0,0},
   {1,0x0046F},{0,0},{1,0x00471},{0,0},{1,0x00473},
   {0,0},{1,0x00475},{0,0},{1,0x00477},{0,0},
   {1,0x00479},{0,0},{1,0x0047B},{0,0},{1,0x0047D},
   {0,0},{1,0x0047F},{0,0},{1,0x00481},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{1,0x0048B},{0,0},
   {1,0x0048D},{0,0},{1,0x0048F},{0,0},{1,0x00491},
   {0,0},{1,0x00493},{0,0},{1,0x00495},{0,0},
   {1,0x00497},{0,0},{1,0x00499},{0,0},{1,0x0049B},
   {0,0},{1,0x0049D},{0,0},{1,0x0049F},{0,0},
   {1,0x004A1},{0,0},{1,0x004A3},{0,0},{1,0x004A5},
   {0,0},{1,0x004A7},{0,0},{1,0x004A9},{0,0},
   {1,0x004AB},{0,0},{1,0x004AD},{0,0},{1,0x004AF},
   {0,0},{1,0x004B1},{0,0},{1,0x004B3},{0,0},
   {1,0x004B5},{0,0},{1,0x004B7},{0,0},{1,0x004B9},
   {0,0},{1,0x004BB},{0,0},{1,0x004BD},{0,0},
   {1,0x004BF},{0,0},{1,0x004CF},{1,0x004C2},{0,0},
   {1,0x004C4},{0,0},{1,0x004C6},{0,0},{1,0x004C8},
   {0,0},{1,0x004CA},{0,0},{1,0x004CC},{0,0},
   {1,0x004CE},{0,0},{0,0},{1,0x004D1},{0,0},
   {1,0x004D3},{0,0},{1,0x004D5},{0,0},{1,0x004D7},
   {0,0},{1,0x004D9},{0,0},{1,0x004DB},{0,0},
   {1,0x004DD},{0,0},{1,0x004DF},{0,0},{1,0x004E1},
   {0,0},{1,0x004E3},{0,0},{1,0x004E5},{0,0},
   {1,0x004E7},{0,0},{1,0x004E9},{0,0},{1,0x004EB},
   {0,0},{1,0x004ED},{0,0},{1,0x004EF},{0,0},
   {1,0x004F1},{0,0},{1,0x004F3},{0,0},{1,0x004F5},
   {0,0},{1,0x004F7},{0,0},{1,0x004F9},{0,0},
   {1,0x004FB},{0,0},{1,0x004FD},{0,0},{1,0x004FF},
   {0,0}
  },

  /* block 5 */
  {{1,0x00501},{0,0},{1,0x00503},{0,0},{1,0x00505},
   {0,0},{1,0x00507},{0,0},{1,0x00509},{0,0},
   {1,0x0050B},{0,0},{1,0x0050D},{0,0},{1,0x0050F},
   {0,0},{1,0x00511},{0,0},{1,0x00513},{0,0},
   {1,0x00515},{0,0},{1,0x00517},{0,0},{1,0x00519},
   {0,0},{1,0x0051B},{0,0},{1,0x0051D},{0,0},
   {1,0x0051F},{0,0},{1,0x00521},{0,0},{1,0x00523},
   {0,0},{1,0x00525},{0,0},{1,0x00527},{0,0},
   {1,0x00529},{0,0},{1,0x0052B},{0,0},{1,0x0052D},
   {0,0},{1,0x0052F},{0,0},{0,0},{1,0x00561},
   {1,0x00562},{1,0x00563},{1,0x00564},{1,0x00565},{1,0x00566},
   {1,0x00567},{1,0x00568},{1,0x00569},{1,0x0056A},{1,0x0056B},
   {1,0x0056C},{1,0x0056D},{1,0x0056E},{1,0x0056F},{1,0x00570},
   {1,0x00571},{1,0x00572},{1,0x00573},{1,0x00574},{1,0x00575},
   {1,0x00576},{1,0x00577},{1,0x00578},{1,0x00579},{1,0x0057A},
   {1,0x0057B},{1,0x0057C},{1,0x0057D},{1,0x0057E},{1,0x0057F},
   {1,0x00580},{1,0x00581},{1,0x00582},{1,0x00583},{1,0x00584},
   {1,0x00585},{1,0x00586},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {2,0x0000E},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 6 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 7 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {1,0x02D00},{1,0x02D01},{1,0x02D02},{1,0x02D03},{1,0x02D04},
   {1,0x02D05},{1,0x02D06},{1,0x02D07},{1,0x02D08},{1,0x02D09},
   {1,0x02D0A},{1,0x02D0B},{1,0x02D0C},{1,0x02D0D},{1,0x02D0E},
   {1,0x02D0F},{1,0x02D10},{1,0x02D11},{1,0x02D12},{1,0x02D13},
   {1,0x02D14},{1,0x02D15},{1,0x02D16},{1,0x02D17},{1,0x02D18},
   {1,0x02D19},{1,0x02D1A},{1,0x02D1B},{1,0x02D1C},{1,0x02D1D},
   {1,0x02D1E},{1,0x02D1F},{1,0x02D20},{1,0x02D21},{1,0x02D22},
   {1,0x02D23},{1,0x02D24},{1,0x02D25},{0,0},{1,0x02D27},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {1,0x02D2D},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 8 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{1,0x013F0},{1,0x013F1},
   {1,0x013F2},{1,0x013F3},{1,0x013F4},{1,0x013F5},{0,0},
   {0,0}
  },

  /* block 9 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{1,0x00432},{1,0x00434},
   {1,0x0043E},{1,0x00441},{1,0x00442},{1,0x00442},{1,0x0044A},
   {1,0x00463},{1,0x0A64B},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 10 */
  {{1,0x01E01},{0,0},{1,0x01E03},{0,0},{1,0x01E05},
   {0,0},{1,0x01E07},{0,0},{1,0x01E09},{0,0},
   {1,0x01E0B},{0,0},{1,0x01E0D},{0,0},{1,0x01E0F},
   {0,0},{1,0x01E11},{0,0},{1,0x01E13},{0,0},
   {1,0x01E15},{0,0},{1,0x01E17},{0,0},{1,0x01E19},
   {0,0},{1,0x01E1B},{0,0},{1,0x01E1D},{0,0},
   {1,0x01E1F},{0,0},{1,0x01E21},{0,0},{1,0x01E23},
   {0,0},{1,0x01E25},{0,0},{1,0x01E27},{0,0},
   {1,0x01E29},{0,0},{1,0x01E2B},{0,0},{1,0x01E2D},
   {0,0},{1,0x01E2F},{0,0},{1,0x01E31},{0,0},
   {1,0x01E33},{0,0},{1,0x01E35},{0,0},{1,0x01E37},
   {0,0},{1,0x01E39},{0,0},{1,0x01E3B},{0,0},
   {1,0x01E3D},{0,0},{1,0x01E3F},{0,0},{1,0x01E41},
   {0,0},{1,0x01E43},{0,0},{1,0x01E45},{0,0},
   {1,0x01E47},{0,0},{1,0x01E49},{0,0},{1,0x01E4B},
   {0,0},{1,0x01E4D},{0,0},{1,0x01E4F},{0,0},
   {1,0x01E51},{0,0},{1,0x01E53},{0,0},{1,0x01E55},
   {0,0},{1,0x01E57},{0,0},{1,0x01E59},{0,0},
   {1,0x01E5B},{0,0},{1,0x01E5D},{0,0},{1,0x01E5F},
   {0,0},{1,0x01E61},{0,0},{1,0x01E63},{0,0},
   {1,0x01E65},{0,0},{1,0x01E67},{0,0},{1,0x01E69},
   {0,0},{1,0x01E6B},{0,0},{1,0x01E6D},{0,0},
   {1,0x01E6F},{0,0},{1,0x01E71},{0,0},{1,0x01E73},
   {0,0},{1,0x01E75},{0,0},{1,0x01E77},{0,0},
   {1,0x01E79},{0,0},{1,0x01E7B},{0,0},{1,0x01E7D},
   {0,0},{1,0x01E7F},{0,0},{1,0x01E81},{0,0},
   {1,0x01E83},{0,0},{1,0x01E85},{0,0},{1,0x01E87},
   {0,0},{1,0x01E89},{0,0},{1,0x01E8B},{0,0},
   {1,0x01E8D},{0,0},{1,0x01E8F},{0,0},{1,0x01E91},
   {0,0},{1,0x01E93},{0,0},{1,0x01E95},{0,0},
   {2,0x00010},{2,0x00012},{2,0x00014},{2,0x00016},{2,0x00018},
   {1,0x01E61},{0,0},{0,0},{2,0x0001A},{0,0},
   {1,0x01EA1},{0,0},{1,0x01EA3},{0,0},{1,0x01EA5},
   {0,0},{1,0x01EA7},{0,0},{1,0x01EA9},{0,0},
   {1,0x01EAB},{0,0},{1,0x01EAD},{0,0},{1,0x01EAF},
   {0,0},{1,0x01EB1},{0,0},{1,0x01EB3},{0,0},
   {1,0x01EB5},{0,0},{1,0x01EB7},{0,0},{1,0x01EB9},
   {0,0},{1,0x01EBB},{0,0},{1,0x01EBD},{0,0},
   {1,0x01EBF},{0,0},{1,0x01EC1},{0,0},{1,0x01EC3},
   {0,0},{1,0x01EC5},{0,0},{1,0x01EC7},{0,0},
   {1,0x01EC9},{0,0},{1,0x01ECB},{0,0},{1,0x01ECD},
   {0,0},{1,0x01ECF},{0,0},{1,0x01ED1},{0,0},
   {1,0x01ED3},{0,0},{1,0x01ED5},{0,0},{1,0x01ED7},
   {0,0},{1,0x01ED9},{0,0},{1,0x01EDB},{0,0},
   {1,0x01EDD},{0,0},{1,0x01EDF},{0,0},{1,0x01EE1},
   {0,0},{1,0x01EE3},{0,0},{1,0x01EE5},{0,0},
   {1,0x01EE7},{0,0},{1,0x01EE9},{0,0},{1,0x01EEB},
   {0,0},{1,0x01EED},{0,0},{1,0x01EEF},{0,0},
   {1,0x01EF1},{0,0},{1,0x01EF3},{0,0},{1,0x01EF5},
   {0,0},{1,0x01EF7},{0,0},{1,0x01EF9},{0,0},
   {1,0x01EFB},{0,0},{1,0x01EFD},{0,0},{1,0x01EFF},
   {0,0}
  },

  /* block 11 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{1,0x01F00},{1,0x01F01},
   {1,0x01F02},{1,0x01F03},{1,0x01F04},{1,0x01F05},{1,0x01F06},
   {1,0x01F07},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{1,0x01F10},
   {1,0x01F11},{1,0x01F12},{1,0x01F13},{1,0x01F14},{1,0x01F15},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {1,0x01F20},{1,0x01F21},{1,0x01F22},{1,0x01F23},{1,0x01F24},
   {1,0x01F25},{1,0x01F26},{1,0x01F27},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x01F30},{1,0x01F31},{1,0x01F32},{1,0x01F33},
   {1,0x01F34},{1,0x01F35},{1,0x01F36},{1,0x01F37},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{1,0x01F40},{1,0x01F41},{1,0x01F42},
   {1,0x01F43},{1,0x01F44},{1,0x01F45},{0,0},{0,0},
   {2,0x0001C},{0,0},{3,0x0001E},{0,0},{3,0x00021},
   {0,0},{3,0x00024},{0,0},{0,0},{1,0x01F51},
   {0,0},{1,0x01F53},{0,0},{1,0x01F55},{0,0},
   {1,0x01F57},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{1,0x01F60},
   {1,0x01F61},{1,0x01F62},{1,0x01F63},{1,0x01F64},{1,0x01F65},
   {1,0x01F66},{1,0x01F67},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{2,0x00027},{2,0x00029},
   {2,0x0002B},{2,0x0002D},{2,0x0002F},{2,0x00031},{2,0x00033},
   {2,0x00035},{2,0x00037},{2,0x00039},{2,0x0003B},{2,0x0003D},
   {2,0x0003F},{2,0x00041},{2,0x00043},{2,0x00045},{2,0x00047},
   {2,0x00049},{2,0x0004B},{2,0x0004D},{2,0x0004F},{2,0x00051},
   {2,0x00053},{2,0x00055},{2,0x00057},{2,0x00059},{2,0x0005B},
   {2,0x0005D},{2,0x0005F},{2,0x00061},{2,0x00063},{2,0x00065},
   {2,0x00067},{2,0x00069},{2,0x0006B},{2,0x0006D},{2,0x0006F},
   {2,0x00071},{2,0x00073},{2,0x00075},{2,0x00077},{2,0x00079},
   {2,0x0007B},{2,0x0007D},{2,0x0007F},{2,0x00081},{2,0x00083},
   {2,0x00085},{0,0},{0,0},{2,0x00087},{2,0x00089},
   {2,0x0008B},{0,0},{2,0x0008D},{3,0x0008F},{1,0x01FB0},
   {1,0x01FB1},{1,0x01F70},{1,0x01F71},{2,0x00092},{0,0},
   {1,0x003B9},{0,0},{0,0},{0,0},{2,0x00094},
   {2,0x00096},{2,0x00098},{0,0},{2,0x0009A},{3,0x0009C},
   {1,0x01F72},{1,0x01F73},{1,0x01F74},{1,0x01F75},{2,0x0009F},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {3,0x000A1},{3,0x000A4},{0,0},{0,0},{2,0x000A7},
   {3,0x000A9},{1,0x01FD0},{1,0x01FD1},{1,0x01F76},{1,0x01F77},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{3,0x000AC},{3,0x000AF},{2,0x000B2},{0,0},
   {2,0x000B4},{3,0x000B6},{1,0x01FE0},{1,0x01FE1},{1,0x01F7A},
   {1,0x01F7B},{1,0x01FE5},{0,0},{0,0},{0,0},
   {0,0},{0,0},{2,0x000B9},{2,0x000BB},{2,0x000BD},
   {0,0},{2,0x000BF},{3,0x000C1},{1,0x01F78},{1,0x01F79},
   {1,0x01F7C},{1,0x01F7D},{2,0x000C4},{0,0},{0,0},
   {0,0}
  },

  /* block 12 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{1,0x003C9},{0,0},
   {0,0},{0,0},{1,0x0006B},{1,0x000E5},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {1,0x0214E},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x02170},{1,0x02171},{1,0x02172},{1,0x02173},
   {1,0x02174},{1,0x02175},{1,0x02176},{1,0x02177},{1,0x02178},
   {1,0x02179},{1,0x0217A},{1,0x0217B},{1,0x0217C},{1,0x0217D},
   {1,0x0217E},{1,0x0217F},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x02184},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 13 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{1,0x024D0},{1,0x024D1},{1,0x024D2},
   {1,0x024D3},{1,0x024D4},{1,0x024D5},{1,0x024D6},{1,0x024D7},
   {1,0x024D8},{1,0x024D9},{1,0x024DA},{1,0x024DB},{1,0x024DC},
   {1,0x024DD},{1,0x024DE},{1,0x024DF},{1,0x024E0},{1,0x024E1},
   {1,0x024E2},{1,0x024E3},{1,0x024E4},{1,0x024E5},{1,0x024E6},
   {1,0x024E7},{1,0x024E8},{1,0x024E9},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 14 */
  {{1,0x02C30},{1,0x02C31},{1,0x02C32},{1,0x02C33},{1,0x02C34},
   {1,0x02C35},{1,0x02C36},{1,0x02C37},{1,0x02C38},{1,0x02C39},
   {1,0x02C3A},{1,0x02C3B},{1,0x02C3C},{1,0x02C3D},{1,0x02C3E},
   {1,0x02C3F},{1,0x02C40},{1,0x02C41},{1,0x02C42},{1,0x02C43},
   {1,0x02C44},{1,0x02C45},{1,0x02C46},{1,0x02C47},{1,0x02C48},
   {1,0x02C49},{1,0x02C4A},{1,0x02C4B},{1,0x02C4C},{1,0x02C4D},
   {1,0x02C4E},{1,0x02C4F},{1,0x02C50},{1,0x02C51},{1,0x02C52},
   {1,0x02C53},{1,0x02C54},{1,0x02C55},{1,0x02C56},{1,0x02C57},
   {1,0x02C58},{1,0x02C59},{1,0x02C5A},{1,0x02C5B},{1,0x02C5C},
   {1,0x02C5D},{1,0x02C5E},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x02C61},{0,0},{1,0x0026B},{1,0x01D7D},
   {1,0x0027D},{0,0},{0,0},{1,0x02C68},{0,0},
   {1,0x02C6A},{0,0},{1,0x02C6C},{0,0},{1,0x00251},
   {1,0x00271},{1,0x00250},{1,0x00252},{0,0},{1,0x02C73},
   {0,0},{0,0},{1,0x02C76},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x0023F},{1,0x00240},{1,0x02C81},{0,0},
   {1,0x02C83},{0,0},{1,0x02C85},{0,0},{1,0x02C87},
   {0,0},{1,0x02C89},{0,0},{1,0x02C8B},{0,0},
   {1,0x02C8D},{0,0},{1,0x02C8F},{0,0},{1,0x02C91},
   {0,0},{1,0x02C93},{0,0},{1,0x02C95},{0,0},
   {1,0x02C97},{0,0},{1,0x02C99},{0,0},{1,0x02C9B},
   {0,0},{1,0x02C9D},{0,0},{1,0x02C9F},{0,0},
   {1,0x02CA1},{0,0},{1,0x02CA3},{0,0},{1,0x02CA5},
   {0,0},{1,0x02CA7},{0,0},{1,0x02CA9},{0,0},
   {1,0x02CAB},{0,0},{1,0x02CAD},{0,0},{1,0x02CAF},
   {0,0},{1,0x02CB1},{0,0},{1,0x02CB3},{0,0},
   {1,0x02CB5},{0,0},{1,0x02CB7},{0,0},{1,0x02CB9},
   {0,0},{1,0x02CBB},{0,0},{1,0x02CBD},{0,0},
   {1,0x02CBF},{0,0},{1,0x02CC1},{0,0},{1,0x02CC3},
   {0,0},{1,0x02CC5},{0,0},{1,0x02CC7},{0,0},
   {1,0x02CC9},{0,0},{1,0x02CCB},{0,0},{1,0x02CCD},
   {0,0},{1,0x02CCF},{0,0},{1,0x02CD1},{0,0},
   {1,0x02CD3},{0,0},{1,0x02CD5},{0,0},{1,0x02CD7},
   {0,0},{1,0x02CD9},{0,0},{1,0x02CDB},{0,0},
   {1,0x02CDD},{0,0},{1,0x02CDF},{0,0},{1,0x02CE1},
   {0,0},{1,0x02CE3},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {1,0x02CEC},{0,0},{1,0x02CEE},{0,0},{0,0},
   {0,0},{0,0},{1,0x02CF3},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 15 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{1,0x0A641},
   {0,0},{1,0x0A643},{0,0},{1,0x0A645},{0,0},
   {1,0x0A647},{0,0},{1,0x0A649},{0,0},{1,0x0A64B},
   {0,0},{1,0x0A64D},{0,0},{1,0x0A64F},{0,0},
   {1,0x0A651},{0,0},{1,0x0A653},{0,0},{1,0x0A655},
   {0,0},{1,0x0A657},{0,0},{1,0x0A659},{0,0},
   {1,0x0A65B},{0,0},{1,0x0A65D},{0,0},{1,0x0A65F},
   {0,0},{1,0x0A661},{0,0},{1,0x0A663},{0,0},
   {1,0x0A665},{0,0},{1,0x0A667},{0,0},{1,0x0A669},
   {0,0},{1,0x0A66B},{0,0},{1,0x0A66D},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{1,0x0A681},{0,0},
   {1,0x0A683},{0,0},{1,0x0A685},{0,0},{1,0x0A687},
   {0,0},{1,0x0A689},{0,0},{1,0x0A68B},{0,0},
   {1,0x0A68D},{0,0},{1,0x0A68F},{0,0},{1,0x0A691},
   {0,0},{1,0x0A693},{0,0},{1,0x0A695},{0,0},
   {1,0x0A697},{0,0},{1,0x0A699},{0,0},{1,0x0A69B},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 16 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{1,0x0A723},
   {0,0},{1,0x0A725},{0,0},{1,0x0A727},{0,0},
   {1,0x0A729},{0,0},{1,0x0A72B},{0,0},{1,0x0A72D},
   {0,0},{1,0x0A72F},{0,0},{0,0},{0,0},
   {1,0x0A733},{0,0},{1,0x0A735},{0,0},{1,0x0A737},
   {0,0},{1,0x0A739},{0,0},{1,0x0A73B},{0,0},
   {1,0x0A73D},{0,0},{1,0x0A73F},{0,0},{1,0x0A741},
   {0,0},{1,0x0A743},{0,0},{1,0x0A745},{0,0},
   {1,0x0A747},{0,0},{1,0x0A749},{0,0},{1,0x0A74B},
   {0,0},{1,0x0A74D},{0,0},{1,0x0A74F},{0,0},
   {1,0x0A751},{0,0},{1,0x0A753},{0,0},{1,0x0A755},
   {0,0},{1,0x0A757},{0,0},{1,0x0A759},{0,0},
   {1,0x0A75B},{0,0},{1,0x0A75D},{0,0},{1,0x0A75F},
   {0,0},{1,0x0A761},{0,0},{1,0x0A763},{0,0},
   {1,0x0A765},{0,0},{1,0x0A767},{0,0},{1,0x0A769},
   {0,0},{1,0x0A76B},{0,0},{1,0x0A76D},{0,0},
   {1,0x0A76F},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x0A77A},{0,0},{1,0x0A77C},{0,0},
   {1,0x01D79},{1,0x0A77F},{0,0},{1,0x0A781},{0,0},
   {1,0x0A783},{0,0},{1,0x0A785},{0,0},{1,0x0A787},
   {0,0},{0,0},{0,0},{0,0},{1,0x0A78C},
   {0,0},{1,0x00265},{0,0},{0,0},{1,0x0A791},
   {0,0},{1,0x0A793},{0,0},{0,0},{0,0},
   {1,0x0A797},{0,0},{1,0x0A799},{0,0},{1,0x0A79B},
   {0,0},{1,0x0A79D},{0,0},{1,0x0A79F},{0,0},
   {1,0x0A7A1},{0,0},{1,0x0A7A3},{0,0},{1,0x0A7A5},
   {0,0},{1,0x0A7A7},{0,0},{1,0x0A7A9},{0,0},
   {1,0x00266},{1,0x0025C},{1,0x00261},{1,0x0026C},{1,0x0026A},
   {0,0},{1,0x0029E},{1,0x00287},{1,0x0029D},{1,0x0AB53},
   {1,0x0A7B5},{0,0},{1,0x0A7B7},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 17 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{1,0x013A0},{1,0x013A1},{1,0x013A2},
   {1,0x013A3},{1,0x013A4},{1,0x013A5},{1,0x013A6},{1,0x013A7},
   {1,0x013A8},{1,0x013A9},{1,0x013AA},{1,0x013AB},{1,0x013AC},
   {1,0x013AD},{1,0x013AE},{1,0x013AF},{1,0x013B0},{1,0x013B1},
   {1,0x013B2},{1,0x013B3},{1,0x013B4},{1,0x013B5},{1,0x013B6},
   {1,0x013B7},{1,0x013B8},{1,0x013B9},{1,0x013BA},{1,0x013BB},
   {1,0x013BC},{1,0x013BD},{1,0x013BE},{1,0x013BF},{1,0x013C0},
   {1,0x013C1},{1,0x013C2},{1,0x013C3},{1,0x013C4},{1,0x013C5},
   {1,0x013C6},{1,0x013C7},{1,0x013C8},{1,0x013C9},{1,0x013CA},
   {1,0x013CB},{1,0x013CC},{1,0x013CD},{1,0x013CE},{1,0x013CF},
   {1,0x013D0},{1,0x013D1},{1,0x013D2},{1,0x013D3},{1,0x013D4},
   {1,0x013D5},{1,0x013D6},{1,0x013D7},{1,0x013D8},{1,0x013D9},
   {1,0x013DA},{1,0x013DB},{1,0x013DC},{1,0x013DD},{1,0x013DE},
   {1,0x013DF},{1,0x013E0},{1,0x013E1},{1,0x013E2},{1,0x013E3},
   {1,0x013E4},{1,0x013E5},{1,0x013E6},{1,0x013E7},{1,0x013E8},
   {1,0x013E9},{1,0x013EA},{1,0x013EB},{1,0x013EC},{1,0x013ED},
   {1,0x013EE},{1,0x013EF},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 18 */
  {{2,0x000C6},{2,0x000C8},{2,0x000CA},{3,0x000CC},{3,0x000CF},
   {2,0x000D2},{2,0x000D4},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{2,0x000D6},
   {2,0x000D8},{2,0x000DA},{2,0x000DC},{2,0x000DE},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 19 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{1,0x0FF41},{1,0x0FF42},
   {1,0x0FF43},{1,0x0FF44},{1,0x0FF45},{1,0x0FF46},{1,0x0FF47},
   {1,0x0FF48},{1,0x0FF49},{1,0x0FF4A},{1,0x0FF4B},{1,0x0FF4C},
   {1,0x0FF4D},{1,0x0FF4E},{1,0x0FF4F},{1,0x0FF50},{1,0x0FF51},
   {1,0x0FF52},{1,0x0FF53},{1,0x0FF54},{1,0x0FF55},{1,0x0FF56},
   {1,0x0FF57},{1,0x0FF58},{1,0x0FF59},{1,0x0FF5A},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 20 */
  {{1,0x10428},{1,0x10429},{1,0x1042A},{1,0x1042B},{1,0x1042C},
   {1,0x1042D},{1,0x1042E},{1,0x1042F},{1,0x10430},{1,0x10431},
   {1,0x10432},{1,0x10433},{1,0x10434},{1,0x10435},{1,0x10436},
   {1,0x10437},{1,0x10438},{1,0x10439},{1,0x1043A},{1,0x1043B},
   {1,0x1043C},{1,0x1043D},{1,0x1043E},{1,0x1043F},{1,0x10440},
   {1,0x10441},{1,0x10442},{1,0x10443},{1,0x10444},{1,0x10445},
   {1,0x10446},{1,0x10447},{1,0x10448},{1,0x10449},{1,0x1044A},
   {1,0x1044B},{1,0x1044C},{1,0x1044D},{1,0x1044E},{1,0x1044F},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{1,0x104D8},{1,0x104D9},{1,0x104DA},{1,0x104DB},
   {1,0x104DC},{1,0x104DD},{1,0x104DE},{1,0x104DF},{1,0x104E0},
   {1,0x104E1},{1,0x104E2},{1,0x104E3},{1,0x104E4},{1,0x104E5},
   {1,0x104E6},{1,0x104E7},{1,0x104E8},{1,0x104E9},{1,0x104EA},
   {1,0x104EB},{1,0x104EC},{1,0x104ED},{1,0x104EE},{1,0x104EF},
   {1,0x104F0},{1,0x104F1},{1,0x104F2},{1,0x104F3},{1,0x104F4},
   {1,0x104F5},{1,0x104F6},{1,0x104F7},{1,0x104F8},{1,0x104F9},
   {1,0x104FA},{1,0x104FB},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 21 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{1,0x10CC0},{1,0x10CC1},
   {1,0x10CC2},{1,0x10CC3},{1,0x10CC4},{1,0x10CC5},{1,0x10CC6},
   {1,0x10CC7},{1,0x10CC8},{1,0x10CC9},{1,0x10CCA},{1,0x10CCB},
   {1,0x10CCC},{1,0x10CCD},{1,0x10CCE},{1,0x10CCF},{1,0x10CD0},
   {1,0x10CD1},{1,0x10CD2},{1,0x10CD3},{1,0x10CD4},{1,0x10CD5},
   {1,0x10CD6},{1,0x10CD7},{1,0x10CD8},{1,0x10CD9},{1,0x10CDA},
   {1,0x10CDB},{1,0x10CDC},{1,0x10CDD},{1,0x10CDE},{1,0x10CDF},
   {1,0x10CE0},{1,0x10CE1},{1,0x10CE2},{1,0x10CE3},{1,0x10CE4},
   {1,0x10CE5},{1,0x10CE6},{1,0x10CE7},{1,0x10CE8},{1,0x10CE9},
   {1,0x10CEA},{1,0x10CEB},{1,0x10CEC},{1,0x10CED},{1,0x10CEE},
   {1,0x10CEF},{1,0x10CF0},{1,0x10CF1},{1,0x10CF2},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 22 */
  {{0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {1,0x118C0},{1,0x118C1},{1,0x118C2},{1,0x118C3},{1,0x118C4},
   {1,0x118C5},{1,0x118C6},{1,0x118C7},{1,0x118C8},{1,0x118C9},
   {1,0x118CA},{1,0x118CB},{1,0x118CC},{1,0x118CD},{1,0x118CE},
   {1,0x118CF},{1,0x118D0},{1,0x118D1},{1,0x118D2},{1,0x118D3},
   {1,0x118D4},{1,0x118D5},{1,0x118D6},{1,0x118D7},{1,0x118D8},
   {1,0x118D9},{1,0x118DA},{1,0x118DB},{1,0x118DC},{1,0x118DD},
   {1,0x118DE},{1,0x118DF},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  },

  /* block 23 */
  {{1,0x1E922},{1,0x1E923},{1,0x1E924},{1,0x1E925},{1,0x1E926},
   {1,0x1E927},{1,0x1E928},{1,0x1E929},{1,0x1E92A},{1,0x1E92B},
   {1,0x1E92C},{1,0x1E92D},{1,0x1E92E},{1,0x1E92F},{1,0x1E930},
   {1,0x1E931},{1,0x1E932},{1,0x1E933},{1,0x1E934},{1,0x1E935},
   {1,0x1E936},{1,0x1E937},{1,0x1E938},{1,0x1E939},{1,0x1E93A},
   {1,0x1E93B},{1,0x1E93C},{1,0x1E93D},{1,0x1E93E},{1,0x1E93F},
   {1,0x1E940},{1,0x1E941},{1,0x1E942},{1,0x1E943},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0},{0,0},{0,0},{0,0},{0,0},
   {0,0}
  }
};

static const uint32_t casefold_mapping[] = {
/* 0x0000 */ 0x0073,0x0073,0x0069,0x0307,0x02BC,0x006E,0x006A,0x030C,
/* 0x0008 */ 0x03B9,0x0308,0x0301,0x03C5,0x0308,0x0301,0x0565,0x0582,
/* 0x0010 */ 0x0068,0x0331,0x0074,0x0308,0x0077,0x030A,0x0079,0x030A,
/* 0x0018 */ 0x0061,0x02BE,0x0073,0x0073,0x03C5,0x0313,0x03C5,0x0313,
/* 0x0020 */ 0x0300,0x03C5,0x0313,0x0301,0x03C5,0x0313,0x0342,0x1F00,
/* 0x0028 */ 0x03B9,0x1F01,0x03B9,0x1F02,0x03B9,0x1F03,0x03B9,0x1F04,
/* 0x0030 */ 0x03B9,0x1F05,0x03B9,0x1F06,0x03B9,0x1F07,0x03B9,0x1F00,
/* 0x0038 */ 0x03B9,0x1F01,0x03B9,0x1F02,0x03B9,0x1F03,0x03B9,0x1F04,
/* 0x0040 */ 0x03B9,0x1F05,0x03B9,0x1F06,0x03B9,0x1F07,0x03B9,0x1F20,
/* 0x0048 */ 0x03B9,0x1F21,0x03B9,0x1F22,0x03B9,0x1F23,0x03B9,0x1F24,
/* 0x0050 */ 0x03B9,0x1F25,0x03B9,0x1F26,0x03B9,0x1F27,0x03B9,0x1F20,
/* 0x0058 */ 0x03B9,0x1F21,0x03B9,0x1F22,0x03B9,0x1F23,0x03B9,0x1F24,
/* 0x0060 */ 0x03B9,0x1F25,0x03B9,0x1F26,0x03B9,0x1F27,0x03B9,0x1F60,
/* 0x0068 */ 0x03B9,0x1F61,0x03B9,0x1F62,0x03B9,0x1F63,0x03B9,0x1F64,
/* 0x0070 */ 0x03B9,0x1F65,0x03B9,0x1F66,0x03B9,0x1F67,0x03B9,0x1F60,
/* 0x0078 */ 0x03B9,0x1F61,0x03B9,0x1F62,0x03B9,0x1F63,0x03B9,0x1F64,
/* 0x0080 */ 0x03B9,0x1F65,0x03B9,0x1F66,0x03B9,0x1F67,0x03B9,0x1F70,
/* 0x0088 */ 0x03B9,0x03B1,0x03B9,0x03AC,0x03B9,0x03B1,0x0342,0x03B1,
/* 0x0090 */ 0x0342,0x03B9,0x03B1,0x03B9,0x1F74,0x03B9,0x03B7,0x03B9,
/* 0x0098 */ 0x03AE,0x03B9,0x03B7,0x0342,0x03B7,0x0342,0x03B9,0x03B7,
/* 0x00A0 */ 0x03B9,0x03B9,0x0308,0x0300,0x03B9,0x0308,0x0301,0x03B9,
/* 0x00A8 */ 0x0342,0x03B9,0x0308,0x0342,0x03C5,0x0308,0x0300,0x03C5,
/* 0x00B0 */ 0x0308,0x0301,0x03C1,0x0313,0x03C5,0x0342,0x03C5,0x0308,
/* 0x00B8 */ 0x0342,0x1F7C,0x03B9,0x03C9,0x03B9,0x03CE,0x03B9,0x03C9,
/* 0x00C0 */ 0x0342,0x03C9,0x0342,0x03B9,0x03C9,0x03B9,0x0066,0x0066,
/* 0x00C8 */ 0x0066,0x0069,0x0066,0x006C,0x0066,0x0066,0x0069,0x0066,
/* 0x00D0 */ 0x0066,0x006C,0x0073,0x0074,0x0073,0x0074,0x0574,0x0576,
/* 0x00D8 */ 0x0574,0x0565,0x0574,0x056B,0x057E,0x0576,0x0574,0x056D
};

#endif /* UNICODE_CASEFOLD_H */
