% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_summary_bbdml.R
\name{print.summary.bbdml}
\alias{print.summary.bbdml}
\title{Print summary function}
\usage{
\method{print}{summary.bbdml}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{Object of class \code{bbdml}}

\item{digits}{the number of significant digits to use when printing.}

\item{signif.stars}{logical. If \code{TRUE}, `significance stars' are printed for each coefficient.}

\item{...}{No optional arguments are accepted at this time.}
}
\value{
\code{NULL}. Displays printed model summary.
}
\description{
Print summary function
}
\examples{
data(soil_phylum_small)
mod <- bbdml(formula = OTU.1 ~ DayAmdmt,
phi.formula = ~ DayAmdmt,
data = soil_phylum_small)
print(summary(mod))
}
