% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{distances}
\alias{distances}
\title{Create Core Hunter distance data from matrix or file.}
\usage{
distances(data, file)
}
\arguments{
\item{data}{Symmetric distance matrix. Unique row and column headers are required,
should be the same and are used as item ids. Can be a \code{numeric} matrix or a data frame.
The data frame may optionally include a first column \code{NAME} used to assign names to some
or all individuals. The remaining columns should be \code{numeric}.}

\item{file}{File from which to read the distance matrix.}
}
\value{
Distance matrix data of class \code{chdist} with elements
\describe{
 \item{\code{data}}{Distance matrix (\code{numeric} matrix).}
 \item{\code{size}}{Number of individuals in the dataset.}
 \item{\code{ids}}{Unique item identifiers.}
 \item{\code{names}}{Item names. Names of individuals to which no explicit name
   has been assigned are equal to the unique \code{ids}.}
 \item{\code{java}}{Java version of the data object.}
 \item{\code{file}}{Normalized path of file from which data was read (if applicable).}
}
}
\description{
Specify either a symmetric distance matrix or the file from which to read the matrix.
See \url{www.corehunter.org} for documentation and examples of the distance matrix
file format used by Core Hunter.
}
\examples{
# create from distance matrix
m <- matrix(runif(100), nrow = 10, ncol = 10)
diag(m) <- 0
# make symmetric
m[lower.tri(m)] <- t(m)[lower.tri(m)]
# set headers
rownames(m) <- colnames(m) <- paste("i", 1:10, sep = "-")

dist <- distances(m)

# read from file
dist.file <- system.file("extdata", "distances.csv", package = "corehunter")
dist <- distances(file = dist.file)

}

