% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rootSize.R
\name{rootSize}
\alias{rootSize}
\title{Convert a matrix of semi-processed DICOM images to root particle counts, volumes, and surface areas}
\usage{
rootSize(mat.list, pixelA, diameter.classes = c(1, 2, 2.5, 10),
class.names = diameter.classes,
thickness = 0.625,
airHU = -850.3233,
airSD = 77.6953,
waterHU = 63.912,
waterSD = 14.1728,
pixel.minimum = 4)
}
\arguments{
\item{mat.list}{list of DICOM images for a sediment core (values in Hounsfield Units)}

\item{pixelA}{pixel area (mm2)}

\item{diameter.classes}{an integer vector of diameter cut points. Units are mm (zero is added in automatically).}

\item{class.names}{not used presently}

\item{thickness}{CT image thickness (mm)}

\item{airHU}{mean value for air-filled calibration rod (all rod arguments are in Hounsfield Units)}

\item{airSD}{standard deviation for air-filled calibration rod}

\item{waterHU}{mean value for water-filled calibration rod}

\item{waterSD}{standard deviation for water-filled calibration rod}

\item{pixel.minimum}{minimum number of pixels needed for a clump to be identified as a root}
}
\value{
value \code{rootSize} returns a dataframe with one row per CT slice. Values returned are the number, volume (cm3), and surface area (cm2) of particles in each size class with an upper bound defined in \code{diameter.classes}.
}
\description{
Calculates the number of root/rhizome particles, volumes,  and surface areas, for different size classes.  This approach  directly replicates Earl Davey's manual classification approach. This method is deprecated as of coreCT version 1.3.0.
}
\details{
Calculates the number of root/rhizome particles, volumes, and surface areas, for different size classes. This function requires that values be Hounsfield Units (i.e., data must be semi-processed from the raw DICOM imagery).
}
\examples{
ct.slope <- unique(extractHeader(core_426$hdr, "RescaleSlope"))
ct.int   <- unique(extractHeader(core_426$hdr, "RescaleIntercept")) 
# convert raw units to Hounsfield units
HU_426 <- lapply(core_426$img, function(x) x*ct.slope + ct.int)

rootChars <- rootSize(HU_426, pixelA = 0.0596,
diameter.classes = c(2.5, 10))

\dontrun{
# plot using "ggplot" package after transforming with "reshape2" package
area.long <- reshape2::melt(rootChars, id.vars = c("depth"), 
   measure.vars = grep("Area", names(rootChars)))
ggplot2::ggplot(data = area.long, ggplot2::aes(y = -depth, x = value, 
   color = variable)) + ggplot2::geom_point() + ggplot2::theme_classic() + 
   ggplot2::xlab("root external surface area per slice (cm2)")
}

}
\seealso{
\code{\link{conv}}
}
