% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCoreSet.R
\name{plotCoreSet}
\alias{plotCoreSet}
\title{Plot Core Set for cooperative production linear games.}
\usage{
plotCoreSet(c, A, B)
}
\arguments{
\item{c}{vector containing the benefits of the products.}

\item{A}{production matrix.}

\item{B}{matrix containing the amount of resources of the several players 
where each row is one player.}
}
\value{
\code{plotCoreSet} returns a \code{ggplot} object with the imputation set
of the game, the core and the most common solutions.
}
\description{
Given a linear production game, the 
\code{plotCoreSet} function plots the imputation Set, Core Set and the most common
solutions (Nucleolus, Shapley Value and allocations 
of the Owen Set).
}
\details{
In most cases the Owen Set consists of a single allocation, but in some cases there are infinities.
In the case that there are infinite allocations, if the problem has two dimensions, 
they will be given by a line, which we will represent graphically.
If the problem has more than two dimensions, an allocation of all possible ones will be represented.
}
\examples{
# Vector of benefits
c <- c(68, 52)
# Production matrix
A <- matrix(c(4, 5, 6, 2), ncol = 2, byrow = TRUE)
# Matrix of resources. Each row is the vector of resources of each player
B <- matrix(c(4, 6, 60, 33, 39, 0), ncol = 3, byrow = TRUE)
# Solution of the associated linear production game
plotCoreSet(c, A, B)
  
  
}
\seealso{
\code{\link{coopProductGame}}
}
\author{
D. Prieto
}
