% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{get_cookie}
\alias{get_cookie}
\title{Read a cookie}
\usage{
get_cookie(
  cookie_name,
  missing = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{cookie_name}{The name of the cookie. Can contain any US-ASCII
characters except for: the control character, space, a tab, or separator
characters like ( ) < > @ , ; : \\ " / [ ] ? = \{ \}.}

\item{missing}{The value to return if the requested cookie does not exist.
Defaults to NULL.}

\item{session}{Shiny session in which the cookies can be found (the default
should probably always be used).}
}
\value{
A character with the value of the cookie.
}
\description{
Read a cookie from the input object.
}
\examples{
server <- function(input, output, session) {
  get_cookie("my_cookie")
}
}
