% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyjdiv.R
\name{svyjdiv}
\alias{svyjdiv}
\alias{svyjdiv.survey.design}
\alias{svyjdiv.svyrep.design}
\alias{svyjdiv.DBIsvydesign}
\title{J-divergence measure (EXPERIMENTAL)}
\usage{
svyjdiv(formula, design, ...)

\method{svyjdiv}{survey.design}(formula, design, na.rm = FALSE, ...)

\method{svyjdiv}{svyrep.design}(formula, design, na.rm = FALSE, ...)

\method{svyjdiv}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the j-divergence measure, an entropy-based measure of inequality
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.

This measure only allows for strictly positive variables.
}
\note{
This function is experimental and is subject to change in later versions.
}
\examples{
library(survey)
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)

svyjdiv( ~eqincome , design = subset( des_eusilc , eqincome > 0 ) )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep(des_eusilc_rep)

svyjdiv( ~eqincome , design = subset( des_eusilc_rep , eqincome > 0 ) )

\dontrun{

# linearized design using a variable with missings
svyjdiv( ~py010n , design = subset( des_eusilc , py010n > 0 | is.na( py010n ) ) )
svyjdiv( ~py010n , design = subset( des_eusilc , py010n > 0 | is.na( py010n ) ), na.rm = TRUE )
# replicate-weighted design using a variable with missings
svyjdiv( ~py010n , design = subset( des_eusilc_rep , py010n > 0 | is.na( py010n ) ) )
svyjdiv( ~py010n , design = subset( des_eusilc_rep , py010n > 0 | is.na( py010n ) ) , na.rm = TRUE )

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfolder,
		dbtype="MonetDBLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )

svyjdiv( ~eqincome , design = subset( dbd_eusilc , eqincome > 0 ) )

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Nicholas Rohde (2016). J-divergence measurements of economic inequality.
J. R. Statist. Soc. A, v. 179, Part 3 (2016), pp. 847-870.
URL \url{http://onlinelibrary.wiley.com/doi/10.1111/rssa.12153/abstract}.

Martin Biewen and Stephen Jenkins (2002). Estimation of Generalized Entropy
and Atkinson Inequality Indices from Complex Survey Data. \emph{DIW Discussion Papers},
No.345,
URL \url{https://www.diw.de/documents/publikationen/73/diw_01.c.40394.de/dp345.pdf}.
}
\seealso{
\code{\link{svygei}}
}
\author{
Guilherme Jacob
}
\keyword{survey}
