% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\name{cvx_optim}
\alias{cvx_optim}
\title{Solve optimization problem}
\usage{
cvx_optim(p, solver = c("SCS", "ECOS"), ...)
}
\arguments{
\item{p}{optimization problem to be solved.}

\item{solver}{convex problem solver to be used. Currently \code{convexjlr} supports \code{SCS} and \code{ECOS},
with \code{SCS} solver as the default.}

\item{...}{the optional solver options, like the maximal iteration times.
For the solver options, you can see
\url{http://www.cvxpy.org/tutorial/advanced/index.html#setting-solver-options}
for reference.}
}
\value{
status of optimized problem.
}
\description{
\code{cvx_optim} solves optimization problem using Convex.jl.
}
\examples{
\dontrun{
    convex_setup()
    x <- Variable()
    b <- 1
    p <- minimize(sum((x - b) ^ 2))
    cvx_optim(p)
}
}
