% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Probit-control.R
\name{ProbitControl}
\alias{ProbitControl}
\title{Causal inference in probit outcome models with possibly invalid IVs}
\usage{
ProbitControl(
  Y,
  D,
  Z,
  X = NULL,
  intercept = TRUE,
  invalid = TRUE,
  d1 = NULL,
  d2 = NULL,
  w0 = NULL,
  bs.Niter = 40
)
}
\arguments{
\item{Y}{The outcome observation, a vector of length \eqn{n}.}

\item{D}{The treatment observation, a vector of length \eqn{n}.}

\item{Z}{The instrument observation of dimension \eqn{n \times p_z}.}

\item{X}{The covariates observation of dimension \eqn{n \times p_x}.}

\item{intercept}{Whether the intercept is included. (default = \code{TRUE})}

\item{invalid}{If \code{TRUE}, the method is robust to the presence of possibly invalid IVs; If \code{FALSE}, the method assumes all IVs to be valid. (default = \code{TRUE})}

\item{d1}{A treatment value for computing CATE(d1,d2|w0).}

\item{d2}{A treatment value for computing CATE(d1,d2|w0).}

\item{w0}{A vector of the instruments and baseline covariates for computing CATE(d1,d2|w0).}

\item{bs.Niter}{The bootstrap resampling size for constructing the confidence interval.}
}
\value{
\code{ProbitControl} returns an object of class "SpotIV", which is a list containing the following components:
    \item{\code{betaHat}}{The estimate of the model parameter in front of the treatment.}
    \item{\code{beta.sdHat}}{The estimated standard error of betaHat.}
    \item{\code{cateHat}}{The estimate of CATE(d1,d2|w0).}
    \item{\code{cate.sdHat}}{The estimated standard deviation of \code{cateHat}.}
    \item{\code{SHat}}{The estimated set of relevant IVs.}
    \item{\code{VHat}}{The estimated set of relevant and valid IVs.}
    \item{\code{Maj.pass}}{The indicator that the majority rule is satisfied.}
}
\description{
Perform causal inference in the probit outcome model with possibly invalid IVs.
}
\examples{
data("nonlineardata")
Y <- nonlineardata[,"CVD"]
D <- nonlineardata[,"bmi"]
Z <- as.matrix(nonlineardata[,c("Z.1","Z.2","Z.3","Z.4")])
X <- as.matrix(nonlineardata[,c("age","sex")])
d1 <- median(D)+1
d2 <- median(D)
w0 <- c(rep(0,4), 30, 1)
Probit.model <- ProbitControl(Y,D,Z,X,invalid = TRUE,d1 =d1, d2 = d2,w0 = w0)
summary(Probit.model)


}
\references{
{
Li, S., Guo, Z. (2020), Causal Inference for Nonlinear Outcome Models with Possibly Invalid Instrumental Variables, Preprint \emph{arXiv:2010.09922}.\cr
}
}
