% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chacko_test_1xc.R
\name{Chacko_test_1xc}
\alias{Chacko_test_1xc}
\title{The Chacko test for order-restriction}
\usage{
Chacko_test_1xc(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 1xc vector, where c is the number of categories)}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
A data frame containing the two-sided p-value, the statistic and the
degrees of freedom.
}
\description{
Described in Chapter 3, "The 1xc Table and the Multinomial
Distribution", Chacko (1966) derived a test based on the Pearson chi-square
statistic to test the hypothesis that the categories of a multinomial
variable with \code{c} possible outcomes have a natural ordering. The test
statistic is asymptotically chi-squared distributed.
}
\examples{
# Hypothetical experiment
Chacko_test_1xc(n = c(1, 4, 3, 11, 9))
}
\references{
Chacko, V. J. (1966). Modified chi-square test for ordered alternatives.
Sankhyā: The Indian Journal of Statistics, Series B, 185-190.

Fagerland MW, Lydersen S, Laake P (2017) Statistical Analysis of Contingency
Tables. Chapman & Hall/CRC, Boca Raton, FL.
}
