% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald_CI_CC_1x2.R
\name{Wald_CI_CC_1x2}
\alias{Wald_CI_CC_1x2}
\title{The Wald CI  with CC for the binomial probability}
\usage{
Wald_CI_CC_1x2(X, n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95# CIs}

\item{printresults}{display results (0 = no, 1 = yes)}
}
\value{
A vector containing lower, upper and point estimates of the statistic
}
\description{
The Wald confidence interval with continuity correction for the
binomial probability. Described in Chapter 2 "The 1x2 Table and the Binomial
Distribution"
}
\examples{
# The number of 1st order male births (Singh et al. 2010)
Wald_CI_CC_1x2(X=250, n=533)
# The number of 2nd order male births (Singh et al. 2010)
Wald_CI_CC_1x2(X=204, n=412)
# The number of 3rd order male births (Singh et al. 2010)
Wald_CI_CC_1x2(X=103, n=167)
# The number of 4th order male births (Singh et al. 2010)
Wald_CI_CC_1x2(X=33, n=45)
# Ligarden et al. (2010)
Wald_CI_CC_1x2(X=13, n=16)

}
