% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content_dir.R
\name{content_dir}
\alias{content_dir}
\title{content store home directory}
\usage{
content_dir(
  dir = Sys.getenv("CONTENTID_HOME", rappdirs::user_data_dir("contentid"))
)
}
\arguments{
\item{dir}{directory to be used as the home directory}
}
\description{
A configurable default location for persistent data storage
}
\details{
This function is intended to be called internally with no
arguments.  It will use the directory set by the system environmental
variable CONTENTID_HOME, if set.  Otherwise, it will use the default
location returned by \link[rappdirs:user_data_dir]{rappdirs::user_data_dir} for the application,
\code{contentid}.  Unlike rappdirs function, this function will also
create the directory if it does not yet exist.
}
\examples{

## example using temporary storage: 
Sys.setenv(CONTENTID_HOME=tempdir())
content_dir()

## clean up
Sys.unsetenv("CONTENTID_HOME")

## Or explicitly with an argument:
content_dir(tempdir())
}
