% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{retrieve}
\alias{retrieve}
\title{Retrieve files from the local cache}
\usage{
retrieve(id, dir = content_dir())
}
\arguments{
\item{id}{a \link{content_id}}

\item{dir}{the path we should use for permanent / on-disk storage
of the registry. An appropriate default will be selected (also
configurable using the environmental variable \code{CONTENTID_HOME}),
if not specified.}
}
\value{
path to a local copy of the file.
}
\description{
Retrieve files from the local cache
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\dontshow{ ## Real users won't use a temporary dir
Sys.setenv("CONTENTID_REGISTRIES" = tempdir())
Sys.setenv(CONTENTID_HOME=tempdir())
}

# Store & retrieve local file
vostok_co2 <- system.file("extdata", "vostok.icecore.co2",
                          package = "contentid")
 id <- store(vostok_co2)
 retrieve(id)

\dontshow{ ## Real users won't use a temporary dir
Sys.unsetenv("CONTENTID_REGISTRIES")
Sys.unsetenv("CONTENTID_HOME")
}
\dontshow{\}) # examplesIf}
}
\seealso{
store
}
