% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{perturbResp}
\alias{perturbResp}
\title{perturbResp}
\usage{
perturbResp(ability, item, group, perturbation)
}
\arguments{
\item{ability}{a double - the location of the person on the measure.}

\item{item}{a matrix - the item parameters in the format required by
\code{conquestr::simplef}}

\item{group}{a string - the group this case belongs to. If NULL, the case is
always in this group.}

\item{perturbation}{A matrix - the description of the way this item should be
perturbed. In the format required by \code{conquestr::genResponses}}
}
\value{
A double - the observed response.
}
\description{
Perturbs a response given specified (item) misfit to implied model.
}
\examples{
myN <- 250
myMean <- 0
mySd <- 2
myGroups <- c("gfit", "bfit")
myAbilities <- rnorm(myN, myMean, mySd)
# students with large weights and unperturbed responses (good fit)
#   and students with small weights and perturbed responses (bad fit)
myData <- data.frame(
  ability = myAbilities,
  group = factor(sample(x = myGroups, size = myN, replace = TRUE))
)
myData$weight <- ifelse(myData$group == myGroups[1], 1, 0.001)
myItems <- list()
myItems[[1]] <- matrix(c(
  0, 0, 0   , 1,
  1, 1, -0.2, 1,
  2, 1, 0.2 , 1
), ncol = 4, byrow = TRUE)
myPerturbations<- list()
myPerturbations[[1]] <- list()
myPerturbations[[1]] <- append(myPerturbations[[1]], 1L)
myPerturbations[[1]] <- append(myPerturbations[[1]], "discrimination")
myPerturbations[[1]] <- append(myPerturbations[[1]],  0.50)
myPerturbations[[1]] <- append(myPerturbations[[1]], 0)
myPerturbations[[1]] <- append(myPerturbations[[1]], "bfit")
names(myPerturbations[[1]]) <- c("item", "type", "factor", "pivot", "group")
myResponses <- genResponses(
    abilities = myData$ability, itemParams = myItems, perturbR = myPerturbations,
    groups = myData$group
)
}
\seealso{
\code{\link[=simplef]{simplef()}}, \code{\link[=genResponses]{genResponses()}},
\code{browseVignettes("conquestr")}
}
\keyword{internal}
