% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildModelData.R
\name{buildModelData}
\alias{buildModelData}
\title{Generate Synthetic Data using uncovr API}
\usage{
buildModelData(numOfObs, numOfVars, key, modelObj)
}
\arguments{
\item{numOfObs}{A number. This represents the number of observations in the data. In other words, the number of rows of data that are requested to be generated. The \emph{numOfObs} argument must be a non-negative integer and in the current version, this function accepts a range of 100 to 10,000.}

\item{numOfVars}{A number. This represents the number of independent variables in the data. In other words, the number of columns besides the dependent variable of data that are requested to be generated. The \emph{numOfVars} argument must be a non-negative integer and in the current version, this function accepts a range of 1 to 100.}

\item{key}{An alpha numeric. This is the subscription key that can be sourced from the developer portal of uncovr API available at \emph{https://foyi.developer.azure-api.net/}.}

\item{modelObj}{Optional argument. A glm or lm model object where both the dependent and independent variables are continuous.}
}
\value{
A json with details such as the requested data, model performance metrics and the model formula.
}
\description{
Please refer to the official documentation of uncovr at \emph{https://www.foyi.co.nz/posts/documentation/documentationuncovr/} for a detailed explanation. This function generates data i.e. independent variables and dependent variable. Besides these variables, this function sources the linear function i.e. model formula.This function needs to be used along with other function such as \code{\link{extractDf}} so as to extract relevant portions of the response.
}
\details{
This is a function that helps in sending the details of the requested data to uncovr API end point and source its response. The purpose of this function can be best understood when explained within the context that is given below. There is a closed source SaaS(Software as a Service) software named \emph{uncovr} that provides an API(Application Programming Interface). In its current state, the SaaS software is free to use with some constraints around the volume of data and the frequency of API calls. One of the functions of \emph{uncovr} API takes an input of number of observations i.e. rows and number of independent variables namely columns and gives an output. The input of the \emph{uncovr} function is required to be sent as part of the body of the html POST functionality. This function \emph{buildModelData} creates the json in the form required by \emph{uncovr} API and sources the response. This function uses an internal function \code{\link{uncovrApi}} to connect to the API endpoint and uses another internal function namely \code{\link{genIndepDepJson}} to build the necessary body of the POST function.
}
