% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amendment.R
\name{cong_amendment}
\alias{cong_amendment}
\title{Request Amendment Information}
\usage{
cong_amendment(
  congress = NULL,
  type = NULL,
  number = NULL,
  item = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. 81 or later are supported.}

\item{type}{Type of amendment. Can be \code{'hamdt'}, \code{'samdt'}, or '\verb{suamdt'}.}

\item{number}{Amendment assigned number. Numeric.}

\item{item}{Information to request. Can be \code{'actions'}, \code{'amendments'}, or \code{'cosponsors'}}

\item{from_date}{start date for search, e.g. \code{'2022-04-01'}. Defaults to most recent.}

\item{to_date}{end date for search, e.g. \code{'2022-04-03'}. Defaults to most recent.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
\code{tibble} or HTTP response if \code{clean = FALSE}.
}
\description{
Request Amendment Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Requires API Key

cong_amendment()

cong_amendment(congress = 117)

cong_amendment(congress = 117, type = 'samdt', number = 2137)

cong_amendment(congress = 117, type = 'samdt', number = 2137, item = 'actions')

\dontshow{\}) # examplesIf}
}
