% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_margin_cfa.R
\name{expected_margin_cfa}
\alias{expected_margin_cfa}
\title{Expected frequencies using margins}
\usage{
expected_margin_cfa(Pfreq, blank = NULL)
}
\arguments{
\item{Pfreq}{Object of class "Pfreq" (see. function \code{\link{dat2fre}}).}

\item{blank}{Either (1) character vector defining the pattern (with spaces between variable categories), which will be ignored for calculation of expected frequencies; or (2) a numeric vector defining the position(s) of the pattern in object of class \code{"Pfreq"}, which will be ignored for calculation of expected frequencies. At default (\code{blank=NULL}) all possible pattern, as listed in object of class \code{"Pfreq"}, are included for calculation of expected frequencies.}
}
\value{
An vector object giving the expected counts.
}
\description{
Calculates the expected frequencies of counts based on the margins of the k-dimensional contingency table.
}
\details{
only main effects are considered.
}
\examples{
#######################################
# expected counts for LienertLSD data example.
data(LienertLSD) # load example data
expected_margin_cfa(Pfreq = LienertLSD) # calculation of expected counts (only main effects).
####################################### 
}
\references{
No references in the moment
}

