\name{conc}

\alias{conc}

\title{Specify a Concave Shape-Restriction in a SHAPEREG Formula}

\description{A symbolic routine to define that the mean vector is concave in a predictor in a formula argument to coneproj.}

\usage{conc(x, numknots = 0, knots = 0, space = "E")}

\arguments{
  \item{x}{A numeric predictor which has the same length as the response vector.}
   \item{numknots}{The number of knots used to smoothly constrain a predictor. The value should be \eqn{0} for a shape-restricted predictor without smoothing. The default value is \eqn{0}.}
  \item{knots}{The knots used to smoothly constrain a predictor. The value should be \eqn{0} for a shape-restricted predictor without smoothing. The default value is \eqn{0}.}
 \item{space}{A character specifying the method to create knots. It will not be used for a shape-restricted predictor without smoothing. The default value is "E".}
}

\value{The vector x with the shape attribute, i.e., shape: 4 ("concave").}

\details{
  "conc" returns the vector "x" and imposes on it two attributes: name and shape. 
  
   The shape attribute is 4 ("concave"), and according to the value of the vector itself and this attribute, the cone edges of the cone generated by the constraint matrix, which constrains the relationship between the mean vector and "x" to be concave,  will be made. The cone edges are a set of basis employed in the hinge algorithm. 

  Note that "conc" does not make the corresponding cone edges itself. It sets things up to a subroutine called makedelta in coneproj.

  See references cited in this section for more details.
}

\references{
   Meyer, M. C. (2013b) A simple new algorithm for quadratic programming with applications in statistics. \emph{Communications in Statistics \bold{42(5)}}, 1126--1139. 
}

\author{
  Mary C. Meyer and Xiyue Liao
}

\examples{
  x <- seq(-1, 2, by = 0.1)
  n <- length(x)
  y <- - x^2 + rnorm(n, .3)  

  # regress y on x under the shape-restriction: "concave"
  ans <- shapereg(y ~ conc(x))

  # make a plot
  plot(x, y)
  lines(x, fitted(ans), col = 2)
  legend("bottomleft", bty = "n", "shapereg: concave fit", col = 2, lty = 1)
}

\keyword{shape routine}
