\name{powerplant}
\alias{powerplant}

\title{
  Tuefekci's powerplant data
}

\description{
  The dataset contains 9568 data points collected from a Combined Cycle Power 
  Plant over 6 years (2006-2011), when the power plant was set to work with full
  load. Features consist of hourly average ambient variables Temperature (T), 
  Ambient Pressure (AP), Relative Humidity (RH) and Exhaust Vacuum (V) to 
  predict the net hourly electrical energy output (EP) of the plant.
  
  A combined cycle power plant (CCPP) is composed of gas turbines (GT), steam 
  turbines (ST) and heat recovery steam generators. In a CCPP, the electricity 
  is generated by gas and steam turbines, which are combined in one cycle, and 
  is transferred from one turbine to another. While the Vacuum is colected from 
  and has effect on the Steam Turbine, the other three of the ambient variables 
  affect the GT performance.
}

\format{
9568 observations on 5 continuous variables.
}

\source{
  UCI repository. 
  \url{https://archive.ics.uci.edu/ml/datasets/Combined+Cycle+Power+Plant}
}

\references{
  Tuefekci, P. (2014), Prediction of full load electrical power output of a base 
  load operated combined cycle power plant using machine learning methods, 
  \emph{International Journal of Electrical Power & Energy Systems}, \bold{60}, 
  pp. 126-140, ISSN 0142-0615.
}

\examples{
data(powerplant)
head(powerplant)
}

\keyword{ powerplant }
