% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condor_rm.R
\name{condor_rm}
\alias{condor_rm}
\title{Condor Remove}
\usage{
condor_rm(job.id = NULL, all = FALSE, top.dir = "condor",
  session = NULL)
}
\arguments{
\item{job.id}{a vector of integers or directory names, indicating Condor jobs
to stop.}

\item{all}{whether to stop all Condor jobs owned by user.}

\item{top.dir}{top directory on submitter machine that contains Condor run
directories.}

\item{session}{optional object of class \code{ssh_connect}.}
}
\value{
No return value, called for side effects.
}
\description{
Stop Condor jobs.
}
\details{
The \code{top.dir} argument only has an effect when \code{job.id} is a vector
of directory names. For example, \code{condor_rm("01_this")} will stop the
Condor job corresponding to directory \code{condor/01_this} on the submitter
machine.

The default value of \code{session = NULL} looks for a \code{session} object
in the user workspace. This allows the user to run Condor functions without
explicitly specifying the \code{session}.
}
\examples{
\dontrun{

# General workflow
session <- ssh_connect("servername")

condor_submit()
condor_q()
condor_dir()
condor_download()  # after job has finished

# Stop one or multiple jobs
condor_rm(123456)                   # stop one job (integer)
condor_rm(c(123456, 123789))        # stop two jobs (integers)
condor_rm("01_this")                # stop one job (dirname)
condor_rm(c("01_this", "02_that"))  # stop two jobs (dirnames)
condor_rm(all=TRUE)                 # stop all jobs
}

}
\seealso{
\code{\link{condor_submit}}, \code{\link{condor_q}},
\code{\link{condor_dir}}, and \code{condor_download} provide the main Condor
interface.

\code{\link{condor_rm}} stops Condor jobs and \code{\link{condor_rmdir}}
removes directories on the submitter machine.

\code{\link{condor-package}} gives an overview of the package.
}
\author{
Nan Yao and Arni Magnusson.
}
