% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{cs_example}
\alias{cs_example}
\title{Load Example Files}
\usage{
cs_example(path, overwrite = FALSE)
}
\arguments{
\item{path}{File path where example data should be placed}

\item{overwrite}{Overwrite files if they exist. If this is FALSE and the file exists
an error will be thrown.}
}
\description{
Adds a sample set of twelve files, one for each month of 2017,
    to the specified path. These are not full data files; each file has twenty
    observations. They can be used to practice preparing, loading, standardizing,
    and collapsing data.
}
\examples{
# create temporary directory
tmpdir <- tempdir()
fs::dir_create(paste0(tmpdir,"/data/"))

# load sample files into temporary directory
cs_example(path = paste0(tmpdir,"/data/"))

# list files
list.files(paste0(tmpdir,"/data/"))

# delete data
fs::dir_delete(paste0(tmpdir,"/data/"))

}
