% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address.R
\name{cs_address}
\alias{cs_address}
\title{Create a Single Address Field}
\usage{
cs_address(.data, address, street, newVar)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{address}{Name of address number variable (typically either \code{ILEADSAddress}
or \code{CADAddress})}

\item{street}{Name of street name variable (typically either \code{ILEADSStreet}
or \code{CADStreet})}

\item{newVar}{Name of new variable to store concatenated address}
}
\value{
A copy of the object with a character vector that contains the concatenated
    street address data.
}
\description{
The street address data in SLMPD releases (either \code{ILEADSAddress} and
    \code{ILEADSStreet} or \code{CADAddress} and \code{CADStreet}) are stored in separate
    columns. In order to faciliate geocoding, this function combines the fields and
    removes inappropriate characters in the address fields.
}
\examples{
# load example data
testData <- january2018

# add concatenated address variable
testData <- cs_address(testData, address = ileads_address, street = ileads_street, newVar = address)

}
