% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomtourney.R
\name{randomtourney}
\alias{randomtourney}
\title{Generates a randomized tournament with random outcomes}
\usage{
randomtourney(n, matchups = 2, pties = 0, ints = 100, type = "char")
}
\arguments{
\item{n}{Number of individuals in tournament}

\item{matchups}{Number of times individuals compete in tournament. Can
be a numeric input, or, if \strong{\code{matchups}="random"} interactions
are random}

\item{pties}{Probability of each individual matchup ending in a tie.
Default is 0, i.e. no ties.  Needs to be a number between 0 and 1.}

\item{ints}{The number of interactions in the tournament if matchups
are set to random.}

\item{type}{Whether to return results as W/L characters or 1/2 numbers.
\strong{\code{type}="char"} is the default, \strong{\code{type}="nums"}
 returns 1/2 numbers referring to winner as id1 or id2}
}
\value{
A competition results dataframe
}
\description{
Generates a randomized tournament with random outcomes
}
\section{Further details}{

Specify number of individuals to compete in a tournament and
the number of times they compete with each other.  Winners
and losers are determined at random. The resulting dataframe
will have variables: \code{id1}, \code{id2}, \code{result}.
Result refers to the outcome from \code{id1}'s perspective, i.e. a "W"
refers to \code{id1} beating \code{id2}, and a "L" refers to
\code{id2} beating \code{id1}. Individuals are referred to by a
random assignment of two conjoined letters.
}
\examples{
randomtourney(20,2) #20 individuals interact twice with each other
randomtourney(5,6) #5 individuals interact six times with each other
randomtourney(8) #8 individuals interact twice with each other
}

