% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdbrmsd.R
\name{pdbrmsd}
\alias{pdbrmsd}
\title{Root Mean Squared Deviation (RMSD) of Two Protein Conformations}
\usage{
pdbrmsd(pdb1, pdb2, start, end, type='all', optimal=FALSE)
}
\arguments{
\item{pdb1}{PDB object containing reference coordinates of atoms in protein conformation.}

\item{pdb2}{PDB object containing coordinates of atoms in protein conformation to compare with pdb1.}

\item{start}{The starting residue position for the RMSD calculation. If not supplied, defaults to first residue of chain.}

\item{end}{The ending residue position for the RMSD calculation. If not supplied, defaults to final residue of chain.}

\item{type}{Specifies atoms to be included in the calculation.  Can be 'all', 'CA' (CA atoms only), or 'backbone' (CA, N, C, O).}

\item{optimal}{Apply optimal rotation and superposition? As described in 
\url{https://cnx.org/contents/HV-RsdwL@23/Molecular-Distance-Measures}}
}
\value{
Returns a list with calculated RMSD value and the optimal rotation matrix.
}
\description{
RMSD calculation between the atoms of two PDB objects.
}
\details{
Similar to \link[bio3d]{rmsd}, but with implementation in C++.
}
\examples{
pdbrmsd(nat879, pred879, start=10, end=20, 'all', optimal=TRUE)

}
