% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAD.R
\name{calcAD}
\alias{calcAD}
\alias{ankledraft}
\alias{ad}
\title{PPD with Ankle Draft}
\usage{
calcAD(ta, tr, vel, rh, clo, met, vAnkle)
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}

\item{met}{a numeric value presenting metabolic rate in [met]}

\item{vAnkle}{air speed at the 0.1 m (4 in.) above the floor [m/s]}
}
\value{
Predicted Percentage of Dissatisfied occupants with ankle draft in [\%]

Acceptability in [boolean]
}
\description{
Function to calculate ankle draft using the predicted percentage of dissatisfied.
}
\details{
Calculates the percentage of thermally dissatisfied people with the ankle draft (0.1 m) above floor level.This equation is only applicable for velocity < 0.2 m/s (40 fps)
}
\examples{
calcAD(25,25,0.2,50,0.5,1.2,0.3) # returns Ankle_draft_ppd:18.6, Acceptability:TRUE
}
\references{
Original code in Python by Tartarini & Schiavon (2020) <doi:10.1016/j.softx.2020.100578>
}
\author{
Code implemented in to R by Shoaib Sarwar. Further contribution by Marcel Schweiker.
}
