% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desaturate.R
\name{desaturate}
\alias{desaturate}
\title{Desaturate Colors by Chroma Removal in HCL Space}
\usage{
desaturate(col, amount = 1, ...)
}
\arguments{
\item{col}{vector of R colors. Can be any of the three kinds of R colors, i.e.,
either a color name (an element of \code{\link[grDevices]{colors}}), a hexadecimal string
of the form \code{"#rrggbb"} or \code{"#rrggbbaa"} (see
\code{\link[grDevices]{rgb}}), or an integer \code{i} meaning
\code{palette()[i]}. Input \code{col} can also be a matrix with three
rows containing R/G/B (0-255) values, see details.}

\item{amount}{numeric specifying the amount of desaturation where \code{1}
corresponds to complete desaturation, \code{0} to no desaturation, and
values in between to partial desaturation.}

\item{...}{additional arguments. If \code{severity} is specified it will
overrule the input argument \code{amount} (for convenience).}
}
\value{
A character vector with (s)RGB codings of the colors in the palette
if input \code{col} is a vector. If input \code{col} is a matrix with R/G/B
values a matrix of the same form and size will be returned.
}
\description{
Transform a vector of given colors to the corresponding colors with chroma
reduced (by a tunable amount) in HCL space.
}
\details{
If input \code{col} is a vector given colors are first transformed to RGB
(either using \code{\link[colorspace]{hex2RGB}} or
\code{\link[grDevices]{col2rgb}}) and then to HCL
(\code{\link[colorspace]{polarLUV}}).  In HCL, chroma is reduced
and then the color is transformed back to a hexadecimal
string.

If input \code{col} is a matrix with three rows named \code{R}, \code{G}, and
\code{B} (top down) they are interpreted as Red-Green-Blue values within the
range \code{[0-255]}. The desaturation takes place in the HCL space as well.
Instead of an (s)RGB color vector a matrix of the same size as the input
\code{col} with desaturated Red-Green-Blue values will be returned.
This can be handy to avoid too many conversions.
}
\examples{
## rainbow of colors and their desaturated counterparts
rainbow_hcl(12)
desaturate(rainbow_hcl(12))

## convenience demo function
wheel <- function(col, radius = 1, ...)
  pie(rep(1, length(col)), col = col, radius = radius, ...) 

## compare base and colorspace palettes
## (in color and desaturated)
par(mar = rep(0, 4), mfrow = c(2, 2))
## rainbow color wheel
wheel(rainbow_hcl(12))
wheel(rainbow(12))
wheel(desaturate(rainbow_hcl(12)))
wheel(desaturate(rainbow(12)))

## apply desaturation directly on RGB values
RGB <- t(hex2RGB(rainbow(3))@coords * 255)
desaturate(RGB)
}
\seealso{
\code{\link[colorspace]{polarLUV}}, \code{\link[colorspace]{hex}}, \code{\link[colorspace]{lighten}}
}
\keyword{color}
