% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{ggplotly_background}
\alias{ggplotly_background}
\title{Prepare ggplot object to ggplotly-compatible layer and image layer}
\usage{
ggplotly_background(
  g,
  repel_color = TRUE,
  repel_label = TRUE,
  encircle = FALSE,
  mascarade = FALSE,
  width = 5,
  height = 5,
  filename = "temp.png",
  draw_box = NULL,
  background = NULL,
  background_alpha = 1,
  use_cairo = FALSE,
  label_lim = 0.05,
  ggbuild = NULL,
  crop = TRUE,
  size_nudge = 0,
  ...
)
}
\arguments{
\item{g}{ggplot plot object}

\item{repel_color}{whether to rearrange colors}

\item{repel_label}{whether to add centroid labels with ggrepel}

\item{encircle}{whether to draw geom_encircle by cluster}

\item{mascarade}{use mascarade package to outline clusters}

\item{width}{plot width}

\item{height}{plot height}

\item{filename}{temp file location for saving image}

\item{draw_box}{if a colored background should be included}

\item{background}{if specified, use this ggplot object or file as background instead}

\item{background_alpha}{alpha value of background image}

\item{use_cairo}{whether to use cairo for saving plots, maybe needed for certain ggplot extensions}

\item{label_lim}{whether to limit labels to avoid edge fraction}

\item{ggbuild}{already built ggplot_built object if available}

\item{crop}{whether to call cropping of the background image to remove whitespace}

\item{size_nudge}{slight image size adjustment, default to none}

\item{...}{arguments passed to gg_color_repel}
}
\value{
plotly object with background image of layers unsupported by plotly
}
\description{
Prepare ggplot object to ggplotly-compatible layer and image layer
}
\examples{
a <- ggplot2::ggplot(ggplot2::mpg, ggplot2::aes(displ, hwy)) +
  ggplot2::geom_point(ggplot2::aes(color = as.factor(cyl)))
new_colors <- color_repel(a)
b <- ggplotly_background(a, filename = NULL)
}
