\name{twolines}
\alias{twolines}
\docType{data}
\title{
A simulated 2-lines test data in 3D
}
\description{
The test data is a simulated 3D dataset of 2-colored lines, i.e., red, green, whose pivots intersect at the origin in the unit box [-1, 1] x [-1, 1] x [-1, 1].
}
\usage{data("twolines")}
\format{
  A data frame with the precise x,y,z coordinates of 426 signal points with marked colors for their memberships. The x,y,z coordinates are within the interval [-1,1].
  \describe{
    \item{\code{x}}{the x coordinate}
    \item{\code{y}}{the y coordinate}
    \item{\code{z}}{the z coordinate}
    \item{\code{membership}}{a factor with levels \code{red} and \code{green}}
  }
}
\details{
The pivots of the red and green lines are respectively, (t,0,0), (t*cos(atan(5)), t*sin(atan(5)), 0). The number of points along each pivot within the unit box is Poisson(200). The t values are generated by the uniform distribution. The perturbations for locations of all signals are generated independently in the orthogonal plane away from the pivot with zero mean and SD = 0.1 for the displacements together with the uniformly distributed random rotations.
}
\source{
From Xueyan Liu, Jiahui Xu, Cheng Cheng, Hui Zhang.
}
\references{
N/A
}
\examples{
data("twolines")

\donttest{
library(rgl)
plot3d(twolines[,c("x","y","z")], type = 's', size = 0.8, col = twolines$membership)
aspect3d("iso")}
}
