% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth.R
\name{getBandwidth}
\alias{getBandwidth}
\alias{getBandwidthAnd}
\alias{getBandwidthNW}
\title{Automatic Bandwidth Selection}
\usage{
getBandwidth(u, bandwidth = c("and", "nw"), kernel, ..., check = TRUE)

getBandwidthAnd(u, kernel = c("ba", "pa", "qs", "th", "tr"), check = TRUE)

getBandwidthNW(u, kernel = c("ba", "pa", "qs"), inter = FALSE,
  u.weights = NULL, check = TRUE)
}
\arguments{
\item{u}{[\code{numeric}]\cr
Data on which to apply the bandwidth selction.}

\item{bandwidth}{[\code{character(1)}]\cr
The bandwidth selection method to use. Default is Andrews (1991) (\code{"and"}),
an alternative is Newey West (1994) (\code{"nw"}).}

\item{kernel}{[\code{character(1)}]\cr
The kernel function to use for selecting the bandwidth.
Default is Bartlett kernel (\code{"ba"}), see Details for alternatives.}

\item{...}{Arguments passed to \code{getBandwidthNW}.}

\item{check}{[\code{logical}]\cr
Wheather to check (and if necessary convert) the arguments.
See \code{\link{checkVars}} for further information.}

\item{inter}{[\code{logical}]\cr
The first column will be ignored, if \code{TRUE} (intercept).
Default is \code{FALSE}.}

\item{u.weights}{[\code{numeric}]\cr
How to weight the columns of \code{u}.
If \code{NULL} (default), uses identical weights for all columns.}
}
\value{
[\code{numeric(1)}]. Bandwidth
}
\description{
Automatic bandwidth selection of Andrews (1991) and of Newey and West (1994).
}
\details{
For Andrews (1991), the AR(1) individual version is implemented.

The kernel that is used for calculating the long-run variance can be
one of the following:
\itemize{
  \item \code{"ba"}: Bartlett kernel
  \item \code{"pa"}: Parzen kernel
  \item \code{"qs"}: Quadratic Spectral kernel
  \item \code{"th"}: Tukey-Hanning kernel (only if \code{bandwidth = "and"})
  \item \code{"tr"}: Truncated kernel (only if \code{bandwidth = "and"})
}
}
\section{Functions}{
\itemize{
\item \code{getBandwidthAnd}: Automatic bandwidth selection of Andrews (1991).

\item \code{getBandwidthNW}: Automatic bandwidth selection of Newey and West (1994).
}}
\examples{
set.seed(1909)
x <- rnorm(100)
getBandwidth(x, kernel = "ba")
getBandwidth(x, bandwidth = "nw", kernel = "ba")

x2 <- arima.sim(model = list(ar = c(0.7, 0.2)), innov = x, n = 100)
getBandwidth(x2, kernel = "qs")
getBandwidth(x2, bandwidth = "nw", kernel = "qs")

}
\references{
\itemize{
    \item Andrews, D.W.K. (1991): "Heteroskedasticity and Autocorrelation
    Consistent Covariance Matrix Estimation," \emph{Econometrica}, 59,
    817--854, \href{http://dx.doi.org/10.2307/2938229}{DOI:10.2307/2938229}.
    \item Newey, W.K. and K.D. West (1994): "Automatic Lag Selection in
    Covariance Matrix Estimation", \emph{Review of Economic Studies}, 61,
    631--653, \href{http://dx.doi.org/10.2307/2297912}{DOI:10.2307/2297912}.
  }
}
\seealso{
\code{\link{getLongRunVar}}
}

