% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coindeskr.R
\name{get_historic_price}
\alias{get_historic_price}
\title{Extract historic  Price of Bitcoin for the given time period and given currency}
\usage{
get_historic_price(currency = "USD", start = Sys.Date() - 2,
  end = Sys.Date() - 1)
}
\arguments{
\item{currency}{a valid ISO 4217 currency code supported by coindesk - verify with get_currency_list(), default is USD}

\item{start}{start date supplied in the YYYY-MM-DD format, e.g. 2013-09-01 for September 1st, 2013. default is current date - 2}

\item{end}{end date supplied in the YYYY-MM-DD format, e.g. 2013-09-01 for September 1st, 2013. default is current date - 1}
}
\value{
Dataframe with the requested currency Price as one column and Date as rownames
}
\description{
Extract historic  Price of Bitcoin for the given time period and given currency
}
\examples{
get_historic_price()
}
