% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_pop_merge.R
\name{feat_pop_merge}
\alias{feat_pop_merge}
\title{Feature: Population Merge}
\usage{
feat_pop_merge(time, pop_source, pop_target)
}
\arguments{
\item{time}{The time at which the merge occurs.}

\item{pop_source}{The population from which all lines are moved.}

\item{pop_target}{The population to which the lines are moved.}
}
\description{
View backwards in time, this feature merges a population into another.
Forwards in time, this corresponds to a speciation event.
}
\details{
Additionally, to the merge all migration rates from and the growth rate of
the source population will be set to 0 at the time of the merge to mimic
a speciation event forwards in time.
}
\examples{
model <- coal_model(c(25,25), 100) +
  feat_pop_merge(0.5, 2, 1) +
  feat_mutation(5)
}

