% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmpproc.r
\name{cmpproc}
\alias{cmpproc}
\title{COM Poisson Process Parameter Estimation.}
\usage{
cmpproc(counts, s = 1, h.out = FALSE)
}
\arguments{
\item{counts}{A vector (-like object) of counts.}

\item{s}{The time interval corresponding to the levels of the counts vector.}

\item{h.out}{A boolean indicating if the information matrix and associated standard errors are returned.
This can have a significant impact on processing time and should be left at the default unless needed}
}
\value{
\code{cmpproc} will return a list of seven elements: [1] se (Standard errors), [2] H (Information matrix), [3] lambda,
    [4] nu, [5] Z, [6] ll (Log likelihood), and [7] aic.
}
\description{
\code{cmpproc} computes the maximum likelihood estimates of a COM-Poisson process for given count data.
}
\examples{
## Standard usage
data(floodcount)
cmpproc(floodcount$Counts)

}
