% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bezier.R
\name{bezier}
\alias{bezier}
\alias{qbezier}
\alias{cbezier}
\title{Bezier curves}
\usage{
qbezier(x, y, t)

cbezier(x, y, t)
}
\arguments{
\item{x}{a vector of x values}

\item{y}{a vector of y values}

\item{t}{a vector of t values for which the curve will be computed}
}
\value{
a list composed of an x-vector and a y-vector
}
\description{
Find the quadratic and cubic Bezier curve for the given points
}
\details{
\code{qbezier} finds the quadratic Bezier curve for the
given three points and \code{cbezier} finds the cubic Bezier curve
for the given four points.  The curve will be computed at all values
in the vector \code{t} and a list of x and y values returned.
}
\examples{
x <- c(1, 2, 3)
y <- c(2, 3, 5)
f <- qbezier(x, y, seq(0, 1, 1/100))

x <- c(-1, 1, 0, -2)
y <- c(-2, 2, -1, -1)
f <- cbezier(x, y, seq(0, 1, 1/100))

}
\seealso{
Other interp: \code{\link{bilinear}},
  \code{\link{cubicspline}}, \code{\link{linterp}},
  \code{\link{nn}}, \code{\link{polyinterp}},
  \code{\link{pwiselinterp}}
}
