% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goldsect.R
\name{goldsect}
\alias{goldsect}
\alias{goldsectmax}
\alias{goldsectmin}
\title{Golden Section Search}
\usage{
goldsectmin(f, a, b, tol = 0.001, m = 100)

goldsectmax(f, a, b, tol = 0.001, m = 100)
}
\arguments{
\item{f}{function to integrate}

\item{a}{the a bound of the search region}

\item{b}{the b bound of the search region}

\item{tol}{the error tolerance}

\item{m}{the maximum number of iterations}
}
\value{
the \code{x} value of the minimum found
}
\description{
Use golden section search to find local extrema
}
\details{
The golden section search  method functions by repeatedly dividing the interval
between \code{a} and \code{b} and will return when the
interval between them is less than \code{tol}, the error tolerance.
However, this implementation also stop if after \code{m}
iterations.
}
\examples{
f <- function(x) { x^2 - 3 * x + 3 }
goldsectmin(f, 0, 5)

}
\seealso{
Other optimz: \code{\link{bisection}},
  \code{\link{gradient}}, \code{\link{hillclimbing}},
  \code{\link{newton}}, \code{\link{sa}},
  \code{\link{secant}}
}

