% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cps.ma.normal.R
\name{cps.ma.normal}
\alias{cps.ma.normal}
\title{Simulation-based power estimation for continuous outcome multi-arm
cluster-randomized trials.}
\usage{
cps.ma.normal(
  nsim = 1000,
  nsubjects = NULL,
  narms = NULL,
  nclusters = NULL,
  means = NULL,
  sigma_sq = NULL,
  sigma_b_sq = NULL,
  alpha = 0.05,
  quiet = FALSE,
  ICC = NULL,
  method = "glmm",
  multi_p_method = "bonferroni",
  allSimData = FALSE,
  seed = NA,
  cores = NULL,
  poorFitOverride = FALSE,
  lowPowerOverride = FALSE,
  tdist = FALSE,
  return.all.models = FALSE,
  optmethod = "nlminb",
  nofit = FALSE,
  timelimitOverride = TRUE
)
}
\arguments{
\item{nsim}{Number of datasets to simulate; accepts integer (required).}

\item{nsubjects}{Number of subjects per cluster (required); accepts an
integer if all are equal and \code{narms} and \code{nclusters} are provided.
Alternately, the user can supply a list with one entry per arm if the
cluster sizes are the same within the arm, or, if they are not the same
within the arms, the user can supply a list of vectors where each vector
represents an arm and each entry in the vector is the number of subjects
per cluster.}

\item{narms}{Integer value representing the number of arms.}

\item{nclusters}{An integer or vector of integers representing the number
of clusters in each arm.}

\item{means}{Expected absolute treatment effect for each arm; accepts a
vector of length \code{narms} (required).}

\item{sigma_sq}{Within-cluster variance; accepts a vector of length
\code{narms} (required).}

\item{sigma_b_sq}{Between-cluster variance; accepts a vector of length
\code{narms} (required).}

\item{alpha}{Significance level; default = 0.05.}

\item{quiet}{When set to FALSE, displays simulation progress and estimated
completion time; default is FALSE.}

\item{ICC}{The intra-cluster correlation coefficient}

\item{method}{Analytical method, either Generalized Linear Mixed Effects
Model (GLMM) or Generalized Estimating Equation (GEE). Accepts c('glmm',
'gee') (required); default = 'glmm'.}

\item{multi_p_method}{A string indicating the method to use for adjusting
p-values for multiple comparisons. Choose one of "holm", "hochberg",
"hommel", "bonferroni", "BH", "BY", "fdr", or "none" to leave p-values
unadjusted. The default is "bonferroni". See \code{?p.adjust} for additional
details.}

\item{allSimData}{Option to output list of all simulated datasets;
default = FALSE.}

\item{seed}{Option to set.seed. Default is NULL.}

\item{cores}{a string ("all") or numeric value indicating the number of cores to be
used for parallel computing.}

\item{poorFitOverride}{Option to override \code{stop()} if more than 25\%
of fits fail to converge; default = FALSE.}

\item{lowPowerOverride}{Option to override \code{stop()} if the power
is less than 0.5 after the first 50 simulations and every ten simulations
thereafter. On function execution stop, the actual power is printed in the
stop message. Default = FALSE. When TRUE, this check is ignored and the
calculated power is returned regardless of value.}

\item{tdist}{Logical; use t-distribution instead of normal distribution
for simulation values, default = FALSE.}

\item{return.all.models}{Logical; Returns all of the fitted models, the simulated data,
the overall model comparisons, and the convergence report vector. This is equivalent
to the output of cps.ma.normal.internal(). See ?cps.ma.normal.internal() for details.}

\item{optmethod}{Option to fit with a different optimizer. Default is 'nlminb', but some
incompatible model types will trigger a list of compatible optimizer options.}

\item{nofit}{Option to skip model fitting and analysis and return the simulated data.
Defaults to \code{FALSE}.}

\item{timelimitOverride}{Logical. When FALSE, stops execution if the estimated completion time
is more than 2 minutes. Defaults to TRUE.}
}
\value{
A list with the following components:
\describe{
  \item{power}{
  Data frame with columns "Power" (Estimated statistical power),
               "lower.95.ci" (Lower 95\% confidence interval bound),
               "upper.95.ci" (Upper 95\% confidence interval bound).
               Note that non-convergent models are returned for review,
               but not included in this calculation.
               }
  \item{model.estimates}{
  Produced only when allSimData=TRUE, data frame with columns
  corresponding to each arm with the suffixes as follows:
                  ".Estimate" (Estimate of treatment effect for a given
                  simulation),
                  "Std.Err" (Standard error for treatment effect estimate),
                  ".tval" (for GLMM) | ".wald" (for GEE),
                  ".pval"
                  }
  \item{overall.power.table}{
  Produced only when allSimData=TRUE, table of F-test (when
  method="glmm") or chi-squared (when method="gee") significance test
  results.
  }
  \item{overall.power.summary}{
  Overall power of model compared to H0. Omits non-convergent models.
  }
  \item{simulated.data}{
  If \code{allSimData = TRUE}, a list of \code{nsim} data frames, each containing:
                  "y" (Simulated response value),
                  "trt" (Indicator for arm),
                  "clust" (Indicator for cluster).
                  }
  \item{model.fit.warning.percent}{
  Character string containing the percent of \code{nsim} in which the
  glmm fit was singular or failed to converge, produced only when
  method == "glmm" & allSimData==FALSE.
  }
  \item{model.fit.warning.incidence}{
  Vector of length \code{nsim} denoting whether
  or not a simulation glmm fit triggered a "singular fit"
  or "non-convergence" error, produced only when
  method = "glmm" & allSimData=TRUE.
  }
  }
If \code{nofit = T}, a data frame of the simulated data sets, containing:
\itemize{
  \item "arm" (Indicator for treatment arm)
  \item "cluster" (Indicator for cluster)
  \item "y1" ... "yn" (Simulated response value for each of the \code{nsim} data sets).
  }
}
\description{
This function uses iterative simulations to determine
approximate power for multi-arm cluster-randomized controlled trials with a
normally-distributed outcome of interest. Users can modify a variety of
parameters to suit the simulations to their desired experimental situation.
This function returns the summary power values for each arm.
}
\details{
Users must specify the desired number of simulations, the group/arm means,
and two of the following: ICC, within-cluster variance, or between-cluster
variance. Significance level, analytic method, progress updates,
poor/singular fit override, and simulated data set output may also be
specified. This function validates the user's input and passes the necessary
arguments to an internal function, which performs the simulations. The
internal function can be called directly by the user to return the fitted
models rather than the power summaries (see \code{?cps.ma.normal.internal}
for details).

Users must also supply the number of arms, the subjects per
cluster, and the number of clusters per arm. For a balanced design,
users can provide these values with the arguments \code{narms},
\code{nsubjects}, and \code{nclusters}, respectively. For unbalanced
designs, the user may provide a list of vectors with one vector per arm,
with each vector containing the number of subjects per cluster. See the
examples provided below for a demonstration of the various input options.

Non-convergent models are not included in the calculation of exact confidence
intervals.
}
\section{Testing details}{

This function has been verified, where possible, against reference values from the NIH's GRT
Sample Size Calculator, PASS11, \code{CRTsize::n4means}, \code{clusterPower::cps.normal}, and
\code{clusterPower::cpa.normal}.
}

\examples{
\dontrun{
nsubjects.example <- list(c(20,20,20,25), c(15, 20, 20, 21), c(17, 20, 21))
means.example <- c(22, 21, 21.5)
sigma_sq.example <- c(1, 1, 0.9)
sigma_b_sq.example <- c(0.1, 0.15, 0.1)

multi.cps.normal.models <- cps.ma.normal(nsim = 100,
                              narms = 3,
                              nsubjects = nsubjects.example,
                              means = means.example,
                              sigma_sq = sigma_sq.example,
                              sigma_b_sq = sigma_b_sq.example,
                              alpha = 0.05,
                              quiet = FALSE, method = 'glmm',
                              seed = 123, cores = "all",
                              lowPowerOverride = FALSE,
                              poorFitOverride = FALSE,
                              optmethod = "nlm")

 multi.cps.normal <- cps.ma.normal(nsim = 100, narms = 3,
                                   nclusters = c(10,11,10), nsubjects = 25,
                                   means = c(1, 0.25, 1.75),
                                   sigma_sq = c(1.2, 1, 1.9),
                                   sigma_b_sq = c(0.5, 1, 0.75),
                                   quiet = FALSE, ICC=NULL, method = 'glmm',
                                   allSimData = FALSE, seed = 123,
                                   poorFitOverride = TRUE,
                                   cores = NULL,
                                   optmethod = "nlminb")

multi.cps.normal.simple <- cps.ma.normal(nsim = 100, narms = 3,
                                  nclusters = 5, nsubjects = 10,
                                  means = c(22.0, 22.5, 22.9),
                                  sigma_sq = 0.2,
                                  sigma_b_sq = 0.2, alpha = 0.05,
                                  quiet = FALSE, ICC=NULL, method = 'glmm',
                                  allSimData = FALSE, seed = 123,
                                  poorFitOverride = TRUE, cores="all",
                                  optmethod = "NLOPT_LN_NELDERMEAD")
}
}
\author{
Alexandria C. Sakrejda (\email{acbro0@umass.edu}), Alexander R. Bogdan,
  and Ken Kleinman (\email{ken.kleinman@gmail.com})
}
