% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cps.did.normal.R
\name{cps.did.normal}
\alias{cps.did.normal}
\title{Power simulations for cluster-randomized trials: Difference in Difference Design, Continuous Outcome.}
\usage{
cps.did.normal(
  nsim = NULL,
  nsubjects = NULL,
  nclusters = NULL,
  delta_mu = 0,
  delta_mu2 = NULL,
  sigma_sq = NULL,
  sigma_b_sq0 = NULL,
  sigma_b_sq1 = 0,
  alpha = 0.05,
  method = "glmm",
  poorFitOverride = FALSE,
  lowPowerOverride = FALSE,
  timelimitOverride = TRUE,
  quiet = FALSE,
  allSimData = FALSE,
  seed = NA,
  nofit = FALSE
)
}
\arguments{
\item{nsim}{Number of datasets to simulate; accepts integer (required).}

\item{nsubjects}{Number of subjects per arm; accepts either a scalar (equal cluster sizes, both groups),
a vector of length two (equal cluster sizes within groups), or a vector of length \code{sum(nclusters)}
(unequal cluster sizes within groups) (required).}

\item{nclusters}{Number of clusters per group; accepts integer scalar or vector of length 2 for unequal number
of clusters per arm (required)}

\item{delta_mu}{Default = 0. Reference arm expected change between from baseline to followup.}

\item{delta_mu2}{Expected change in tretament arm at follow-up; accepts numeric (required).}

\item{sigma_sq}{Within-cluster variance; accepts numeric scalar (indicating equal within-cluster variances for both
arms at both time points) or vector of length 4 specifying within-cluster variance for each arm at each time point.}

\item{sigma_b_sq0}{Pre-treatment (time == 0) between-cluster variance; accepts numeric scalar (indicating equal
between-cluster variances for both arms) or a vector of length 2 specifying treatment-specific
between-cluster variances}

\item{sigma_b_sq1}{Post-treatment (time == 1) between-cluster variance; accepts numeric scalar (indicating equal
between-cluster variances for both arm) or a vector of length 2 specifying treatment-specific
between-cluster variances. For data simulation, sigma_b_sq1 is added to sigma_b_sq0, such that if sigma_b_sq0 = 5
and sigma_b_sq1 = 2, the between-cluster variance at time == 1 equals 7. Default = 0.}

\item{alpha}{Significance level. Default = 0.05.}

\item{method}{Analytical method, either Generalized Linear Mixed Effects Model (GLMM) or
Generalized Estimating Equation (GEE). Accepts c('glmm', 'gee') (required); default = 'glmm'.}

\item{poorFitOverride}{Option to override \code{stop()} if more than 25\%
of fits fail to converge; default = FALSE.}

\item{lowPowerOverride}{Option to override \code{stop()} if the power
is less than 0.5 after the first 50 simulations and every ten simulations
thereafter. On function execution stop, the actual power is printed in the
stop message. Default = FALSE. When TRUE, this check is ignored and the
calculated power is returned regardless of value.}

\item{timelimitOverride}{Logical. When FALSE, stops execution if the estimated completion time
is more than 2 minutes. Defaults to TRUE.}

\item{quiet}{When set to FALSE, displays simulation progress and estimated completion time; default is FALSE.}

\item{allSimData}{Option to output list of all simulated datasets; default = FALSE.}

\item{seed}{Option to set the seed. Default is NA.}

\item{nofit}{Option to skip model fitting and analysis and only return the simulated data.
Default = \code{FALSE}.}
}
\value{
A list with the following components:
\itemize{
  \item Character string indicating total number of simulations and simulation type
  \item Number of simulations
  \item Data frame with columns "Power" (Estimated statistical power),
               "lower.95.ci" (Lower 95% confidence interval bound),
               "upper.95.ci" (Upper 95% confidence interval bound)
  \item Analytic method used for power estimation
  \item Significance level
  \item Vector containing user-defined cluster sizes
  \item Vector containing user-defined number of clusters
  \item Data frame reporting ICC, within & between cluster variances
  for both arms at each time point
  \item Vector containing expected difference between groups based on user inputs
  \item Data frame with columns:
                  "Period" (Pre/Post-treatment indicator),
                  "Arm.2" (arm indicator),
                  "Value" (Mean response value)
  \item Data frame with columns:
                  "Estimate" (Estimate of treatment effect for a given simulation),
                  "Std.err" (Standard error for treatment effect estimate),
                  "Test.statistic" (z-value (for GLMM) or Wald statistic (for GEE)),
                  "p.value",
                  "sig.val" (Is p-value less than alpha?)
  \item If \code{allSimData = TRUE}, a list of data frames, each containing:
                  "y" (Simulated response value),
                  "trt" (Indicator for arm),
                  "clust" (Indicator for cluster),
                  "period" (Indicator for time point)
}
If \code{nofit = T}, a data frame of the simulated data sets, containing:

\itemize{
  \item "arm" (Indicator for treatment arm)
  \item "cluster" (Indicator for cluster)
  \item "y1" ... "yn" (Simulated response value for each of the \code{nsim} data sets).
  }
}
\description{
\loadmathjax

This set of functions utilize iterative simulations to determine
approximate power for difference in difference cluster-randomized controlled trials. Users
can modify a variety of parameters to suit the simulations to their
desired experimental situation.

Runs the power simulation for difference in difference (DID) cluster-randomized controlled trial.

Users must specify the desired number of simulations, number of subjects per
cluster, number of clusters per arm, expected absolute difference
between arms, two of the following: ICC, within-cluster variance, or
between-cluster variance; significance level, analytic method, progress updates,
and simulated data set output may also be specified.
}
\examples{

# Estimate power for a trial with 6 clusters in arm 1 and 6 clusters in arm 2,
# those clusters having 120 subjects each, with sigma_sq = 1. Estimated
# arm mean changes are 0 and 0.48 in the first and second arms, respectively, and we use
# 100 simulated data sets analyzed by the GLMM method. The resulting estimated
# power (for seed = 123) should be 0.81.

\dontrun{
normal.did.rct = cps.did.normal(nsim = 100, nsubjects = 120, nclusters = 6,
                                delta_mu = 0, delta_mu2 = 0.48, sigma_sq = 1, alpha = 0.05,
                                sigma_b_sq0 = 0.1, method = 'glmm', seed = 123)
}

}
\author{
Alexander R. Bogdan

Alexandria C. Sakrejda (\email{acbro0@umass.edu})

Ken Kleinman (\email{ken.kleinman@gmail.com})
}
