% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa.irgtt.binary.R
\name{cpa.irgtt.binary}
\alias{cpa.irgtt.binary}
\title{Power calculations for individually randomized group treatment trials, binary outcome}
\usage{
cpa.irgtt.binary(
  alpha = 0.05,
  power = 0.8,
  nclusters = NA,
  nsubjects = NA,
  ncontrols = NA,
  ICC = NA,
  p2 = NA,
  p1 = NA,
  decrease = TRUE,
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error.}

\item{nclusters}{The number of clusters in the intervention arm.}

\item{nsubjects}{The number of subjects in each cluster in the intervention arm.}

\item{ncontrols}{The number of subjects in the control arm.}

\item{ICC}{The intracluster correlation coefficient, the correlation in outcome measurements between
two individuals from the same cluster in the intervention arm.}

\item{p2}{The expected probability of the outcome in the intervention arm.}

\item{p1}{The expected probability of the outcome in the control arm.}

\item{decrease}{Whether or not the proportion in the intervention arm is expected to be
less than the proportion in the control arm. If TRUE it is assumed p2 < p1, while FALSE implies
p2 > p1.}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed argument.
}
\description{
Compute the power of an individually randomized group treatment trial (IRGTT) design with a binary outcome,
or determine parameters to obtain a target power.
}
\details{
Exactly one of \code{alpha}, \code{power}, \code{nclusters}, \code{nsubjects},
  \code{ncontrols}, \code{ICC}, \code{p2}, and \code{p1}
  must be passed as \code{NA}. Note that \code{alpha} and \code{power}
  have non-\code{NA} defaults, so if those are the parameters of 
  interest they must be explicitly passed as \code{NA}.
}
\section{Note}{

  This function was inspired by work from Stephane Champely (pwr.t.test) and
  Peter Dalgaard (power.t.test). As with those functions, 'uniroot' is used to
  solve power equation for unknowns, so you may see
  errors from it, notably about inability to bracket the root when
  invalid arguments are given.
}

\section{Authors}{

Jonathan Moyer (\email{jon.moyer@gmail.com}), Ken Kleinman (\email{ken.kleinman@gmail.com})
}

\examples{
# Find the required number of subjects per intervention cluster an IRGTT with alpha = 0.05,
# power = 0.80, nclusters = 23, ncontrols = 146, ICC = 0.05, p2 = 0.397, and p1 = 0.243.

cpa.irgtt.binary(nclusters=23, ncontrols = 146, 
  ICC = 0.05, p2 = 0.397, p1 = 0.243, decrease = FALSE)

# 
# The result, nsubjects = 7.96624, suggests 8 subjects per cluster 
# in the intervention arm should be recruited.
# This means that the total number of subjects in the 
# study is nclusters * nsubjects + ncontrols = 23 * 8 + 146 = 330.

}
\references{
Moerbeek, M. and Wong, W. K. (2008) Sample size formulae for trials comparing
group and individual treatments in a multilevel model. Statist. Med., 27:2850-2864. 
doi: 10.1002/sim.3115.
}
