% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa.binary.R
\name{cpa.binary}
\alias{cpa.binary}
\title{Analytic power calculations for parallel arm cluster-randomized trials with binary outcomes}
\usage{
cpa.binary(
  alpha = 0.05,
  power = NA,
  nclusters = NA,
  nsubjects = NA,
  CV = 0,
  p1 = NA,
  p2 = NA,
  ICC = 0.05,
  pooled = FALSE,
  p1inc = TRUE,
  tdist = TRUE,
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error.}

\item{nclusters}{The number of clusters per condition. It must be greater than 1.}

\item{nsubjects}{The mean of the cluster sizes.}

\item{CV}{The coefficient of variation of the cluster sizes. When \code{CV} = 0,
(default) the clusters all have the same size.}

\item{p1}{The proportion with the outcome in one of the conditions, a numeric between 0-1.}

\item{p2}{The proportion with the outcome in the other condition, a numeric between 0-1.}

\item{ICC}{The intraclass correlation, a numeric between 0-1.  (See Details, below.)}

\item{pooled}{Logical indicating if pooled standard error should be used.}

\item{p1inc}{Logical indicating if p1 is expected to be greater than p2.
Only needed if \code{p1} or \code{p2} is \code{NA}.}

\item{tdist}{If \code{TRUE} use t distribution with df equal to (nclusters - 2).
Otherwise use the normal distribution. Default is TRUE.}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed value of the NA parameter (among \code{alpha}, \code{power}, 
  \code{nclusters}, \code{nsubjects},
  \code{CV}, \code{p1}, \code{p2}, and \code{ICC}) needed to satisfy the power and 
  sample size equation.
}
\description{
\loadmathjax

Compute the power, number of clusters needed, number of subjects per cluster needed, 
or other key parameters for a parallel cluster randomized trial with a 
binary outcome.

Exactly one of \code{alpha}, \code{power}, \code{nclusters}, \code{nsubjects},
  \code{CV}, \code{p1}, \code{p2}, and \code{ICC} must be passed as \code{NA}.
  Note that \code{alpha}, \code{power}, and \code{CV} have non-\code{NA}
  defaults, so if those are the parameters of interest they must be
  explicitly passed as \code{NA}.
}
\section{Authors}{

Jonathan Moyer (\email{jon.moyer@gmail.com}), Ken Kleinman (\email{ken.kleinman@gmail.com})
}

\section{Notes}{



This function implements the approach of Donner and Klar (2000). An estimate for the
 intracluster correlation coefficient (ICC) is used to calculate a design effect that 
 accounts for variance inflation due to clustering. 
 
 There are several ways in
 which estimates for the ICC for a binary outcome can be calculated, as described by
 Wu, Crespi, and Wong (2012). The
 user is advised to exercise caution in estimating, generating, and interpreting ICCs in
 this setting.

 Unlike in the case of normal distributed outcomes (cpa.normal), the ICC refers neither to 
 any natural parameter of a data generating model nor to any function of its parameters.   
 For this reason we do not offer the user a option to input
 the variance between the clusters.  If you prefer to use that input, we suggest using the
 cps.binary function.

  This function was inspired by work from Stephane Champely (pwr.t.test) and
  Peter Dalgaard (power.t.test). As with those functions, 'uniroot' is used to
  solve power equation for unknowns, so you may see
  errors from it, notably about inability to bracket the root when
  invalid arguments are given.  This generally means that no solution exists for which the 
  omitted parameter and the supplied parameters fulfill the equation.  In particular, the desired
  power may not be achievable with any number of subjects or clusters.
}

\section{Testing details}{

This function has been verified against reference values from the NIH's GRT
Sample Size Calculator, PASS11, \code{CRTSize::n4props}, 
and \code{clusterPower::cps.binary}.
}

\examples{
# Find the number of clusters per condition needed for a trial with alpha = .05, 
# power = 0.8, 10 observations per cluster, no variation in cluster size, probability
# in condition 1 of .1 and condition 2 of .2, and ICC = 0.1.
\dontrun{
cpa.binary(power = 0.08, nsubjects = 10, p1 = 0.1, p2 = 0.2, ICC = 0.1)
}
# 
# The result, showing nclusters of greater than 37, suggests 38 clusters per 
# condition should be used.

# Find the minimum detectable p2 > p1, given 38 clusters per condition, 10 
# observations per cluster no variation in cluster size, ICC of 0.1, and 
# probability of .1 in condition 2, with power of .8.
\dontrun{
cpa.binary(power = 0.08, nsubjects = 10, nclusters = 38,
  p1 = 0.1, p2 = NA, ICC = 0.1, p1inc = FALSE)
}
# The result shows that p2 greater than 0.198922 can be detected with at 
# least 80\% power.

}
\references{
Donner A, Klar N. Design and Analysis of Cluster Randomization
Trials in Health Research. London; Arnold; 2000.

Wu S, Crespi CM, Wong WK. Comparison of Methods for Estimating Intraclass
Correlation Coefficient for Binary Responses in Cancer Prevention Cluster Randomized
Trials. Contemp Clin Trials. 2012; 33(5): 869-880. doi:10.1016/j.cct.2012.05.004 
London: Arnold; 2000.
}
