% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodna.R
\name{prodna}
\alias{prodna}
\title{Introduce missing values using a missing completely at random mechanism}
\usage{
prodna(X, pct = 0.3)
}
\arguments{
\item{X}{a data frame (or matrix).}

\item{pct}{proportion of missing values. By default pct = 0.3.}
}
\value{
an incomplete data frame
}
\description{
\code{prodna} generates an incomplete dataset by removing a proportion of observed values
}
\examples{
n <- 1000
p <- 5
X <- matrix(runif(n*p), nrow = n, ncol = p)
summary(X)
X.na <- prodna(X)
colMeans(is.na(X.na))
}
