/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CloudFrontSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.cloudfront.AmazonCloudFront;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.CreateDistributionRequest;
import com.amazonaws.services.cloudfront.model.CreateDistributionResult;
import com.amazonaws.services.cloudfront.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront.model.CreateInvalidationResult;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.DeleteDistributionRequest;
import com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResult;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionResult;
import com.amazonaws.services.cloudfront.model.GetInvalidationRequest;
import com.amazonaws.services.cloudfront.model.GetInvalidationResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResult;
import com.amazonaws.services.cloudfront.model.ListDistributionsRequest;
import com.amazonaws.services.cloudfront.model.ListDistributionsResult;
import com.amazonaws.services.cloudfront.model.ListInvalidationsRequest;
import com.amazonaws.services.cloudfront.model.ListInvalidationsResult;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsResult;
import com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResult;
import com.amazonaws.services.cloudfront.model.UpdateDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateDistributionResult;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.BatchTooLargeExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.CNAMEAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.CloudFrontOriginAccessIdentityAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.CloudFrontOriginAccessIdentityInUseExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.CreateCloudFrontOriginAccessIdentityRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.CreateCloudFrontOriginAccessIdentityResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.CreateDistributionRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.CreateDistributionResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.CreateInvalidationRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.CreateInvalidationResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.CreateStreamingDistributionRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.CreateStreamingDistributionResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.DeleteCloudFrontOriginAccessIdentityRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.DeleteDistributionRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.DeleteStreamingDistributionRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.DistributionAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.DistributionNotDisabledExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetCloudFrontOriginAccessIdentityConfigRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetCloudFrontOriginAccessIdentityConfigResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetCloudFrontOriginAccessIdentityRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetCloudFrontOriginAccessIdentityResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetDistributionConfigRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetDistributionConfigResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetDistributionRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetDistributionResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetInvalidationRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetInvalidationResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetStreamingDistributionConfigRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetStreamingDistributionConfigResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetStreamingDistributionRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.GetStreamingDistributionResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.IllegalUpdateExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.InvalidArgumentExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.InvalidDefaultRootObjectExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.InvalidIfMatchVersionExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.InvalidOriginAccessIdentityExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.InvalidOriginExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.InvalidRequiredProtocolExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.ListCloudFrontOriginAccessIdentitiesRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.ListCloudFrontOriginAccessIdentitiesResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.ListDistributionsRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.ListDistributionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.ListInvalidationsRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.ListInvalidationsResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.ListStreamingDistributionsRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.ListStreamingDistributionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.MissingBodyExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.NoSuchCloudFrontOriginAccessIdentityExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.NoSuchDistributionExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.NoSuchInvalidationExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.NoSuchStreamingDistributionExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.PreconditionFailedExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.StreamingDistributionAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.StreamingDistributionNotDisabledExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.TooManyCloudFrontOriginAccessIdentitiesExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.TooManyDistributionCNAMEsExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.TooManyDistributionsExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.TooManyInvalidationsInProgressExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.TooManyStreamingDistributionCNAMEsExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.TooManyStreamingDistributionsExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.TooManyTrustedSignersExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.TrustedSignerDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.UpdateCloudFrontOriginAccessIdentityRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.UpdateCloudFrontOriginAccessIdentityResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.UpdateDistributionRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.UpdateDistributionResultStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.UpdateStreamingDistributionRequestMarshaller;
import com.amazonaws.services.cloudfront.model.transform.UpdateStreamingDistributionResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudFrontClient
extends AmazonWebServiceClient
implements AmazonCloudFront {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private CloudFrontSigner signer;

    public AmazonCloudFrontClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudFrontClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudFrontClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCloudFrontClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new TooManyDistributionsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PreconditionFailedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CNAMEAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CloudFrontOriginAccessIdentityInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TrustedSignerDoesNotExistExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DistributionNotDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new BatchTooLargeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StreamingDistributionNotDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidArgumentExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyStreamingDistributionsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyTrustedSignersExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidRequiredProtocolExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new IllegalUpdateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyCloudFrontOriginAccessIdentitiesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchDistributionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DistributionAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CloudFrontOriginAccessIdentityAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyInvalidationsInProgressExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDefaultRootObjectExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidIfMatchVersionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidOriginExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchInvalidationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StreamingDistributionAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AccessDeniedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingBodyExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyDistributionCNAMEsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchCloudFrontOriginAccessIdentityExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidOriginAccessIdentityExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchStreamingDistributionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyStreamingDistributionCNAMEsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("cloudfront.amazonaws.com/");
        this.signer = new CloudFrontSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudfront/request.handlers"));
    }

    @Override
    public void deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteCloudFrontOriginAccessIdentityRequest> request = new DeleteCloudFrontOriginAccessIdentityRequestMarshaller().marshall(deleteCloudFrontOriginAccessIdentityRequest);
        this.invoke(request, null);
    }

    @Override
    public GetStreamingDistributionConfigResult getStreamingDistributionConfig(GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetStreamingDistributionConfigRequest> request = new GetStreamingDistributionConfigRequestMarshaller().marshall(getStreamingDistributionConfigRequest);
        return this.invoke(request, new GetStreamingDistributionConfigResultStaxUnmarshaller());
    }

    @Override
    public GetInvalidationResult getInvalidation(GetInvalidationRequest getInvalidationRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetInvalidationRequest> request = new GetInvalidationRequestMarshaller().marshall(getInvalidationRequest);
        return this.invoke(request, new GetInvalidationResultStaxUnmarshaller());
    }

    @Override
    public void deleteStreamingDistribution(DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteStreamingDistributionRequest> request = new DeleteStreamingDistributionRequestMarshaller().marshall(deleteStreamingDistributionRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateStreamingDistributionResult createStreamingDistribution(CreateStreamingDistributionRequest createStreamingDistributionRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateStreamingDistributionRequest> request = new CreateStreamingDistributionRequestMarshaller().marshall(createStreamingDistributionRequest);
        return this.invoke(request, new CreateStreamingDistributionResultStaxUnmarshaller());
    }

    @Override
    public CreateDistributionResult createDistribution(CreateDistributionRequest createDistributionRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDistributionRequest> request = new CreateDistributionRequestMarshaller().marshall(createDistributionRequest);
        return this.invoke(request, new CreateDistributionResultStaxUnmarshaller());
    }

    @Override
    public void deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDistributionRequest> request = new DeleteDistributionRequestMarshaller().marshall(deleteDistributionRequest);
        this.invoke(request, null);
    }

    @Override
    public UpdateDistributionResult updateDistribution(UpdateDistributionRequest updateDistributionRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateDistributionRequest> request = new UpdateDistributionRequestMarshaller().marshall(updateDistributionRequest);
        return this.invoke(request, new UpdateDistributionResultStaxUnmarshaller());
    }

    @Override
    public UpdateStreamingDistributionResult updateStreamingDistribution(UpdateStreamingDistributionRequest updateStreamingDistributionRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateStreamingDistributionRequest> request = new UpdateStreamingDistributionRequestMarshaller().marshall(updateStreamingDistributionRequest);
        return this.invoke(request, new UpdateStreamingDistributionResultStaxUnmarshaller());
    }

    @Override
    public CreateCloudFrontOriginAccessIdentityResult createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateCloudFrontOriginAccessIdentityRequest> request = new CreateCloudFrontOriginAccessIdentityRequestMarshaller().marshall(createCloudFrontOriginAccessIdentityRequest);
        return this.invoke(request, new CreateCloudFrontOriginAccessIdentityResultStaxUnmarshaller());
    }

    @Override
    public GetDistributionResult getDistribution(GetDistributionRequest getDistributionRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetDistributionRequest> request = new GetDistributionRequestMarshaller().marshall(getDistributionRequest);
        return this.invoke(request, new GetDistributionResultStaxUnmarshaller());
    }

    @Override
    public GetCloudFrontOriginAccessIdentityConfigResult getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetCloudFrontOriginAccessIdentityConfigRequest> request = new GetCloudFrontOriginAccessIdentityConfigRequestMarshaller().marshall(getCloudFrontOriginAccessIdentityConfigRequest);
        return this.invoke(request, new GetCloudFrontOriginAccessIdentityConfigResultStaxUnmarshaller());
    }

    @Override
    public GetStreamingDistributionResult getStreamingDistribution(GetStreamingDistributionRequest getStreamingDistributionRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetStreamingDistributionRequest> request = new GetStreamingDistributionRequestMarshaller().marshall(getStreamingDistributionRequest);
        return this.invoke(request, new GetStreamingDistributionResultStaxUnmarshaller());
    }

    @Override
    public ListDistributionsResult listDistributions(ListDistributionsRequest listDistributionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListDistributionsRequest> request = new ListDistributionsRequestMarshaller().marshall(listDistributionsRequest);
        return this.invoke(request, new ListDistributionsResultStaxUnmarshaller());
    }

    @Override
    public UpdateCloudFrontOriginAccessIdentityResult updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateCloudFrontOriginAccessIdentityRequest> request = new UpdateCloudFrontOriginAccessIdentityRequestMarshaller().marshall(updateCloudFrontOriginAccessIdentityRequest);
        return this.invoke(request, new UpdateCloudFrontOriginAccessIdentityResultStaxUnmarshaller());
    }

    @Override
    public GetDistributionConfigResult getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetDistributionConfigRequest> request = new GetDistributionConfigRequestMarshaller().marshall(getDistributionConfigRequest);
        return this.invoke(request, new GetDistributionConfigResultStaxUnmarshaller());
    }

    @Override
    public GetCloudFrontOriginAccessIdentityResult getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetCloudFrontOriginAccessIdentityRequest> request = new GetCloudFrontOriginAccessIdentityRequestMarshaller().marshall(getCloudFrontOriginAccessIdentityRequest);
        return this.invoke(request, new GetCloudFrontOriginAccessIdentityResultStaxUnmarshaller());
    }

    @Override
    public CreateInvalidationResult createInvalidation(CreateInvalidationRequest createInvalidationRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateInvalidationRequest> request = new CreateInvalidationRequestMarshaller().marshall(createInvalidationRequest);
        return this.invoke(request, new CreateInvalidationResultStaxUnmarshaller());
    }

    @Override
    public ListCloudFrontOriginAccessIdentitiesResult listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListCloudFrontOriginAccessIdentitiesRequest> request = new ListCloudFrontOriginAccessIdentitiesRequestMarshaller().marshall(listCloudFrontOriginAccessIdentitiesRequest);
        return this.invoke(request, new ListCloudFrontOriginAccessIdentitiesResultStaxUnmarshaller());
    }

    @Override
    public ListStreamingDistributionsResult listStreamingDistributions(ListStreamingDistributionsRequest listStreamingDistributionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListStreamingDistributionsRequest> request = new ListStreamingDistributionsRequestMarshaller().marshall(listStreamingDistributionsRequest);
        return this.invoke(request, new ListStreamingDistributionsResultStaxUnmarshaller());
    }

    @Override
    public ListInvalidationsResult listInvalidations(ListInvalidationsRequest listInvalidationsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListInvalidationsRequest> request = new ListInvalidationsRequestMarshaller().marshall(listInvalidationsRequest);
        return this.invoke(request, new ListInvalidationsResultStaxUnmarshaller());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

